package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.CertificateId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ImportCertificateResponse(certificateId: CertificateId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ImportCertificateResponse = {
    import ImportCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ImportCertificateResponse
      .builder()
      .certificateId(CertificateId.unwrap(certificateId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ImportCertificateResponse.ReadOnly =
    zio.aws.transfer.model.ImportCertificateResponse.wrap(buildAwsValue())
}
object ImportCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ImportCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ImportCertificateResponse =
      zio.aws.transfer.model.ImportCertificateResponse(certificateId)
    def certificateId: CertificateId
    def getCertificateId: ZIO[Any, Nothing, CertificateId] =
      ZIO.succeed(certificateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ImportCertificateResponse
  ) extends zio.aws.transfer.model.ImportCertificateResponse.ReadOnly {
    override val certificateId: CertificateId =
      zio.aws.transfer.model.primitives.CertificateId(impl.certificateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ImportCertificateResponse
  ): zio.aws.transfer.model.ImportCertificateResponse.ReadOnly = new Wrapper(
    impl
  )
}
