package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{UserName, SshPublicKeyId, ServerId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ImportSshPublicKeyResponse(
    serverId: ServerId,
    sshPublicKeyId: SshPublicKeyId,
    userName: UserName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ImportSshPublicKeyResponse = {
    import ImportSshPublicKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ImportSshPublicKeyResponse
      .builder()
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .sshPublicKeyId(SshPublicKeyId.unwrap(sshPublicKeyId): java.lang.String)
      .userName(UserName.unwrap(userName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ImportSshPublicKeyResponse.ReadOnly =
    zio.aws.transfer.model.ImportSshPublicKeyResponse.wrap(buildAwsValue())
}
object ImportSshPublicKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ImportSshPublicKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ImportSshPublicKeyResponse =
      zio.aws.transfer.model
        .ImportSshPublicKeyResponse(serverId, sshPublicKeyId, userName)
    def serverId: ServerId
    def sshPublicKeyId: SshPublicKeyId
    def userName: UserName
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getSshPublicKeyId: ZIO[Any, Nothing, SshPublicKeyId] =
      ZIO.succeed(sshPublicKeyId)
    def getUserName: ZIO[Any, Nothing, UserName] = ZIO.succeed(userName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ImportSshPublicKeyResponse
  ) extends zio.aws.transfer.model.ImportSshPublicKeyResponse.ReadOnly {
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val sshPublicKeyId: SshPublicKeyId =
      zio.aws.transfer.model.primitives.SshPublicKeyId(impl.sshPublicKeyId())
    override val userName: UserName =
      zio.aws.transfer.model.primitives.UserName(impl.userName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ImportSshPublicKeyResponse
  ): zio.aws.transfer.model.ImportSshPublicKeyResponse.ReadOnly = new Wrapper(
    impl
  )
}
