package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAgreementsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    agreements: Iterable[zio.aws.transfer.model.ListedAgreement]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListAgreementsResponse = {
    import ListAgreementsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListAgreementsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .agreements(agreements.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListAgreementsResponse.ReadOnly =
    zio.aws.transfer.model.ListAgreementsResponse.wrap(buildAwsValue())
}
object ListAgreementsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListAgreementsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListAgreementsResponse =
      zio.aws.transfer.model.ListAgreementsResponse(
        nextToken.map(value => value),
        agreements.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def agreements: List[zio.aws.transfer.model.ListedAgreement.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getAgreements: ZIO[Any, Nothing, List[
      zio.aws.transfer.model.ListedAgreement.ReadOnly
    ]] = ZIO.succeed(agreements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListAgreementsResponse
  ) extends zio.aws.transfer.model.ListAgreementsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.transfer.model.primitives.NextToken(value))
    override val agreements
        : List[zio.aws.transfer.model.ListedAgreement.ReadOnly] = impl
      .agreements()
      .asScala
      .map { item =>
        zio.aws.transfer.model.ListedAgreement.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListAgreementsResponse
  ): zio.aws.transfer.model.ListAgreementsResponse.ReadOnly = new Wrapper(impl)
}
