package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFileTransferResultsResponse(
    fileTransferResults: Iterable[
      zio.aws.transfer.model.ConnectorFileTransferResult
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListFileTransferResultsResponse = {
    import ListFileTransferResultsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListFileTransferResultsResponse
      .builder()
      .fileTransferResults(fileTransferResults.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.transfer.model.ListFileTransferResultsResponse.ReadOnly =
    zio.aws.transfer.model.ListFileTransferResultsResponse.wrap(buildAwsValue())
}
object ListFileTransferResultsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListFileTransferResultsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListFileTransferResultsResponse =
      zio.aws.transfer.model.ListFileTransferResultsResponse(
        fileTransferResults.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def fileTransferResults
        : List[zio.aws.transfer.model.ConnectorFileTransferResult.ReadOnly]
    def nextToken: Optional[NextToken]
    def getFileTransferResults: ZIO[Any, Nothing, List[
      zio.aws.transfer.model.ConnectorFileTransferResult.ReadOnly
    ]] = ZIO.succeed(fileTransferResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListFileTransferResultsResponse
  ) extends zio.aws.transfer.model.ListFileTransferResultsResponse.ReadOnly {
    override val fileTransferResults
        : List[zio.aws.transfer.model.ConnectorFileTransferResult.ReadOnly] =
      impl
        .fileTransferResults()
        .asScala
        .map { item =>
          zio.aws.transfer.model.ConnectorFileTransferResult.wrap(item)
        }
        .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.transfer.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListFileTransferResultsResponse
  ): zio.aws.transfer.model.ListFileTransferResultsResponse.ReadOnly =
    new Wrapper(impl)
}
