package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{ServerId, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListHostKeysResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    serverId: ServerId,
    hostKeys: Iterable[zio.aws.transfer.model.ListedHostKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListHostKeysResponse = {
    import ListHostKeysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListHostKeysResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .hostKeys(hostKeys.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListHostKeysResponse.ReadOnly =
    zio.aws.transfer.model.ListHostKeysResponse.wrap(buildAwsValue())
}
object ListHostKeysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListHostKeysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListHostKeysResponse =
      zio.aws.transfer.model.ListHostKeysResponse(
        nextToken.map(value => value),
        serverId,
        hostKeys.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def serverId: ServerId
    def hostKeys: List[zio.aws.transfer.model.ListedHostKey.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getHostKeys: ZIO[Any, Nothing, List[
      zio.aws.transfer.model.ListedHostKey.ReadOnly
    ]] = ZIO.succeed(hostKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListHostKeysResponse
  ) extends zio.aws.transfer.model.ListHostKeysResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.transfer.model.primitives.NextToken(value))
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val hostKeys: List[zio.aws.transfer.model.ListedHostKey.ReadOnly] =
      impl
        .hostKeys()
        .asScala
        .map { item =>
          zio.aws.transfer.model.ListedHostKey.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListHostKeysResponse
  ): zio.aws.transfer.model.ListHostKeysResponse.ReadOnly = new Wrapper(impl)
}
