package zio.aws.transfer.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.transfer.model.primitives.{NextToken, MaxResults}
import scala.jdk.CollectionConverters._
final case class ListProfilesRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    profileType: Optional[zio.aws.transfer.model.ProfileType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListProfilesRequest = {
    import ListProfilesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListProfilesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(profileType.map(value => value.unwrap))(_.profileType)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListProfilesRequest.ReadOnly =
    zio.aws.transfer.model.ListProfilesRequest.wrap(buildAwsValue())
}
object ListProfilesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListProfilesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListProfilesRequest =
      zio.aws.transfer.model.ListProfilesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        profileType.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def profileType: Optional[zio.aws.transfer.model.ProfileType]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProfileType: ZIO[Any, AwsError, zio.aws.transfer.model.ProfileType] =
      AwsError.unwrapOptionField("profileType", profileType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListProfilesRequest
  ) extends zio.aws.transfer.model.ListProfilesRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.transfer.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.transfer.model.primitives.NextToken(value))
    override val profileType: Optional[zio.aws.transfer.model.ProfileType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.profileType())
        .map(value => zio.aws.transfer.model.ProfileType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListProfilesRequest
  ): zio.aws.transfer.model.ListProfilesRequest.ReadOnly = new Wrapper(impl)
}
