package zio.aws.transfer.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.transfer.model.primitives.{
  Description,
  CertDate,
  CertificateId,
  Arn
}
import scala.jdk.CollectionConverters._
final case class ListedCertificate(
    arn: Optional[Arn] = Optional.Absent,
    certificateId: Optional[CertificateId] = Optional.Absent,
    usage: Optional[zio.aws.transfer.model.CertificateUsageType] =
      Optional.Absent,
    status: Optional[zio.aws.transfer.model.CertificateStatusType] =
      Optional.Absent,
    activeDate: Optional[CertDate] = Optional.Absent,
    inactiveDate: Optional[CertDate] = Optional.Absent,
    `type`: Optional[zio.aws.transfer.model.CertificateType] = Optional.Absent,
    description: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListedCertificate = {
    import ListedCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListedCertificate
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        certificateId.map(value =>
          CertificateId.unwrap(value): java.lang.String
        )
      )(_.certificateId)
      .optionallyWith(usage.map(value => value.unwrap))(_.usage)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(activeDate.map(value => CertDate.unwrap(value): Instant))(
        _.activeDate
      )
      .optionallyWith(
        inactiveDate.map(value => CertDate.unwrap(value): Instant)
      )(_.inactiveDate)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListedCertificate.ReadOnly =
    zio.aws.transfer.model.ListedCertificate.wrap(buildAwsValue())
}
object ListedCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListedCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListedCertificate =
      zio.aws.transfer.model.ListedCertificate(
        arn.map(value => value),
        certificateId.map(value => value),
        usage.map(value => value),
        status.map(value => value),
        activeDate.map(value => value),
        inactiveDate.map(value => value),
        `type`.map(value => value),
        description.map(value => value)
      )
    def arn: Optional[Arn]
    def certificateId: Optional[CertificateId]
    def usage: Optional[zio.aws.transfer.model.CertificateUsageType]
    def status: Optional[zio.aws.transfer.model.CertificateStatusType]
    def activeDate: Optional[CertDate]
    def inactiveDate: Optional[CertDate]
    def `type`: Optional[zio.aws.transfer.model.CertificateType]
    def description: Optional[Description]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getCertificateId: ZIO[Any, AwsError, CertificateId] =
      AwsError.unwrapOptionField("certificateId", certificateId)
    def getUsage
        : ZIO[Any, AwsError, zio.aws.transfer.model.CertificateUsageType] =
      AwsError.unwrapOptionField("usage", usage)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.transfer.model.CertificateStatusType] =
      AwsError.unwrapOptionField("status", status)
    def getActiveDate: ZIO[Any, AwsError, CertDate] =
      AwsError.unwrapOptionField("activeDate", activeDate)
    def getInactiveDate: ZIO[Any, AwsError, CertDate] =
      AwsError.unwrapOptionField("inactiveDate", inactiveDate)
    def getType: ZIO[Any, AwsError, zio.aws.transfer.model.CertificateType] =
      AwsError.unwrapOptionField("type", `type`)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListedCertificate
  ) extends zio.aws.transfer.model.ListedCertificate.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.transfer.model.primitives.Arn(value))
    override val certificateId: Optional[CertificateId] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateId())
      .map(value => zio.aws.transfer.model.primitives.CertificateId(value))
    override val usage: Optional[zio.aws.transfer.model.CertificateUsageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usage())
        .map(value => zio.aws.transfer.model.CertificateUsageType.wrap(value))
    override val status
        : Optional[zio.aws.transfer.model.CertificateStatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.transfer.model.CertificateStatusType.wrap(value))
    override val activeDate: Optional[CertDate] = zio.aws.core.internal
      .optionalFromNullable(impl.activeDate())
      .map(value => zio.aws.transfer.model.primitives.CertDate(value))
    override val inactiveDate: Optional[CertDate] = zio.aws.core.internal
      .optionalFromNullable(impl.inactiveDate())
      .map(value => zio.aws.transfer.model.primitives.CertDate(value))
    override val `type`: Optional[zio.aws.transfer.model.CertificateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.transfer.model.CertificateType.wrap(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.transfer.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListedCertificate
  ): zio.aws.transfer.model.ListedCertificate.ReadOnly = new Wrapper(impl)
}
