package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.ExecutionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListedExecution(
    executionId: Optional[ExecutionId] = Optional.Absent,
    initialFileLocation: Optional[zio.aws.transfer.model.FileLocation] =
      Optional.Absent,
    serviceMetadata: Optional[zio.aws.transfer.model.ServiceMetadata] =
      Optional.Absent,
    status: Optional[zio.aws.transfer.model.ExecutionStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListedExecution = {
    import ListedExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListedExecution
      .builder()
      .optionallyWith(
        executionId.map(value => ExecutionId.unwrap(value): java.lang.String)
      )(_.executionId)
      .optionallyWith(initialFileLocation.map(value => value.buildAwsValue()))(
        _.initialFileLocation
      )
      .optionallyWith(serviceMetadata.map(value => value.buildAwsValue()))(
        _.serviceMetadata
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListedExecution.ReadOnly =
    zio.aws.transfer.model.ListedExecution.wrap(buildAwsValue())
}
object ListedExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListedExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListedExecution =
      zio.aws.transfer.model.ListedExecution(
        executionId.map(value => value),
        initialFileLocation.map(value => value.asEditable),
        serviceMetadata.map(value => value.asEditable),
        status.map(value => value)
      )
    def executionId: Optional[ExecutionId]
    def initialFileLocation
        : Optional[zio.aws.transfer.model.FileLocation.ReadOnly]
    def serviceMetadata
        : Optional[zio.aws.transfer.model.ServiceMetadata.ReadOnly]
    def status: Optional[zio.aws.transfer.model.ExecutionStatus]
    def getExecutionId: ZIO[Any, AwsError, ExecutionId] =
      AwsError.unwrapOptionField("executionId", executionId)
    def getInitialFileLocation
        : ZIO[Any, AwsError, zio.aws.transfer.model.FileLocation.ReadOnly] =
      AwsError.unwrapOptionField("initialFileLocation", initialFileLocation)
    def getServiceMetadata
        : ZIO[Any, AwsError, zio.aws.transfer.model.ServiceMetadata.ReadOnly] =
      AwsError.unwrapOptionField("serviceMetadata", serviceMetadata)
    def getStatus: ZIO[Any, AwsError, zio.aws.transfer.model.ExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListedExecution
  ) extends zio.aws.transfer.model.ListedExecution.ReadOnly {
    override val executionId: Optional[ExecutionId] = zio.aws.core.internal
      .optionalFromNullable(impl.executionId())
      .map(value => zio.aws.transfer.model.primitives.ExecutionId(value))
    override val initialFileLocation
        : Optional[zio.aws.transfer.model.FileLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initialFileLocation())
        .map(value => zio.aws.transfer.model.FileLocation.wrap(value))
    override val serviceMetadata
        : Optional[zio.aws.transfer.model.ServiceMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceMetadata())
        .map(value => zio.aws.transfer.model.ServiceMetadata.wrap(value))
    override val status: Optional[zio.aws.transfer.model.ExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.transfer.model.ExecutionStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListedExecution
  ): zio.aws.transfer.model.ListedExecution.ReadOnly = new Wrapper(impl)
}
