package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{As2Id, ProfileId, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListedProfile(
    arn: Optional[Arn] = Optional.Absent,
    profileId: Optional[ProfileId] = Optional.Absent,
    as2Id: Optional[As2Id] = Optional.Absent,
    profileType: Optional[zio.aws.transfer.model.ProfileType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListedProfile = {
    import ListedProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListedProfile
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        profileId.map(value => ProfileId.unwrap(value): java.lang.String)
      )(_.profileId)
      .optionallyWith(
        as2Id.map(value => As2Id.unwrap(value): java.lang.String)
      )(_.as2Id)
      .optionallyWith(profileType.map(value => value.unwrap))(_.profileType)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListedProfile.ReadOnly =
    zio.aws.transfer.model.ListedProfile.wrap(buildAwsValue())
}
object ListedProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListedProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListedProfile =
      zio.aws.transfer.model.ListedProfile(
        arn.map(value => value),
        profileId.map(value => value),
        as2Id.map(value => value),
        profileType.map(value => value)
      )
    def arn: Optional[Arn]
    def profileId: Optional[ProfileId]
    def as2Id: Optional[As2Id]
    def profileType: Optional[zio.aws.transfer.model.ProfileType]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getProfileId: ZIO[Any, AwsError, ProfileId] =
      AwsError.unwrapOptionField("profileId", profileId)
    def getAs2Id: ZIO[Any, AwsError, As2Id] =
      AwsError.unwrapOptionField("as2Id", as2Id)
    def getProfileType: ZIO[Any, AwsError, zio.aws.transfer.model.ProfileType] =
      AwsError.unwrapOptionField("profileType", profileType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListedProfile
  ) extends zio.aws.transfer.model.ListedProfile.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.transfer.model.primitives.Arn(value))
    override val profileId: Optional[ProfileId] = zio.aws.core.internal
      .optionalFromNullable(impl.profileId())
      .map(value => zio.aws.transfer.model.primitives.ProfileId(value))
    override val as2Id: Optional[As2Id] = zio.aws.core.internal
      .optionalFromNullable(impl.as2Id())
      .map(value => zio.aws.transfer.model.primitives.As2Id(value))
    override val profileType: Optional[zio.aws.transfer.model.ProfileType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.profileType())
        .map(value => zio.aws.transfer.model.ProfileType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListedProfile
  ): zio.aws.transfer.model.ListedProfile.ReadOnly = new Wrapper(impl)
}
