package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{Arn, WorkflowDescription, WorkflowId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListedWorkflow(
    workflowId: Optional[WorkflowId] = Optional.Absent,
    description: Optional[WorkflowDescription] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListedWorkflow = {
    import ListedWorkflow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListedWorkflow
      .builder()
      .optionallyWith(
        workflowId.map(value => WorkflowId.unwrap(value): java.lang.String)
      )(_.workflowId)
      .optionallyWith(
        description.map(value =>
          WorkflowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListedWorkflow.ReadOnly =
    zio.aws.transfer.model.ListedWorkflow.wrap(buildAwsValue())
}
object ListedWorkflow {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListedWorkflow
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListedWorkflow =
      zio.aws.transfer.model.ListedWorkflow(
        workflowId.map(value => value),
        description.map(value => value),
        arn.map(value => value)
      )
    def workflowId: Optional[WorkflowId]
    def description: Optional[WorkflowDescription]
    def arn: Optional[Arn]
    def getWorkflowId: ZIO[Any, AwsError, WorkflowId] =
      AwsError.unwrapOptionField("workflowId", workflowId)
    def getDescription: ZIO[Any, AwsError, WorkflowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListedWorkflow
  ) extends zio.aws.transfer.model.ListedWorkflow.ReadOnly {
    override val workflowId: Optional[WorkflowId] = zio.aws.core.internal
      .optionalFromNullable(impl.workflowId())
      .map(value => zio.aws.transfer.model.primitives.WorkflowId(value))
    override val description: Optional[WorkflowDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.transfer.model.primitives.WorkflowDescription(value)
        )
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.transfer.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListedWorkflow
  ): zio.aws.transfer.model.ListedWorkflow.ReadOnly = new Wrapper(impl)
}
