package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait MapType {
  def unwrap: software.amazon.awssdk.services.transfer.model.MapType
}
object MapType {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.MapType
  ): zio.aws.transfer.model.MapType = value match {
    case software.amazon.awssdk.services.transfer.model.MapType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.MapType.FILE =>
      val r = FILE
      r
    case software.amazon.awssdk.services.transfer.model.MapType.DIRECTORY =>
      val r = DIRECTORY
      r
  }
  case object unknownToSdkVersion extends zio.aws.transfer.model.MapType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.MapType =
      software.amazon.awssdk.services.transfer.model.MapType.UNKNOWN_TO_SDK_VERSION
  }
  case object FILE extends zio.aws.transfer.model.MapType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.MapType =
      software.amazon.awssdk.services.transfer.model.MapType.FILE
  }
  case object DIRECTORY extends zio.aws.transfer.model.MapType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.MapType =
      software.amazon.awssdk.services.transfer.model.MapType.DIRECTORY
  }
}
