package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait MdnSigningAlg {
  def unwrap: software.amazon.awssdk.services.transfer.model.MdnSigningAlg
}
object MdnSigningAlg {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.MdnSigningAlg
  ): zio.aws.transfer.model.MdnSigningAlg = value match {
    case software.amazon.awssdk.services.transfer.model.MdnSigningAlg.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.MdnSigningAlg.SHA256 =>
      val r = SHA256
      r
    case software.amazon.awssdk.services.transfer.model.MdnSigningAlg.SHA384 =>
      val r = SHA384
      r
    case software.amazon.awssdk.services.transfer.model.MdnSigningAlg.SHA512 =>
      val r = SHA512
      r
    case software.amazon.awssdk.services.transfer.model.MdnSigningAlg.SHA1 =>
      val r = SHA1
      r
    case software.amazon.awssdk.services.transfer.model.MdnSigningAlg.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.transfer.model.MdnSigningAlg.DEFAULT =>
      val r = DEFAULT
      r
  }
  case object unknownToSdkVersion extends zio.aws.transfer.model.MdnSigningAlg {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.MdnSigningAlg =
      software.amazon.awssdk.services.transfer.model.MdnSigningAlg.UNKNOWN_TO_SDK_VERSION
  }
  case object SHA256 extends zio.aws.transfer.model.MdnSigningAlg {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.MdnSigningAlg =
      software.amazon.awssdk.services.transfer.model.MdnSigningAlg.SHA256
  }
  case object SHA384 extends zio.aws.transfer.model.MdnSigningAlg {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.MdnSigningAlg =
      software.amazon.awssdk.services.transfer.model.MdnSigningAlg.SHA384
  }
  case object SHA512 extends zio.aws.transfer.model.MdnSigningAlg {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.MdnSigningAlg =
      software.amazon.awssdk.services.transfer.model.MdnSigningAlg.SHA512
  }
  case object SHA1 extends zio.aws.transfer.model.MdnSigningAlg {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.MdnSigningAlg =
      software.amazon.awssdk.services.transfer.model.MdnSigningAlg.SHA1
  }
  case object NONE extends zio.aws.transfer.model.MdnSigningAlg {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.MdnSigningAlg =
      software.amazon.awssdk.services.transfer.model.MdnSigningAlg.NONE
  }
  case object DEFAULT extends zio.aws.transfer.model.MdnSigningAlg {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.MdnSigningAlg =
      software.amazon.awssdk.services.transfer.model.MdnSigningAlg.DEFAULT
  }
}
