package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait ProfileType {
  def unwrap: software.amazon.awssdk.services.transfer.model.ProfileType
}
object ProfileType {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.ProfileType
  ): zio.aws.transfer.model.ProfileType = value match {
    case software.amazon.awssdk.services.transfer.model.ProfileType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.ProfileType.LOCAL =>
      val r = LOCAL
      r
    case software.amazon.awssdk.services.transfer.model.ProfileType.PARTNER =>
      val r = PARTNER
      r
  }
  case object unknownToSdkVersion extends zio.aws.transfer.model.ProfileType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.ProfileType =
      software.amazon.awssdk.services.transfer.model.ProfileType.UNKNOWN_TO_SDK_VERSION
  }
  case object LOCAL extends zio.aws.transfer.model.ProfileType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.ProfileType =
      software.amazon.awssdk.services.transfer.model.ProfileType.LOCAL
  }
  case object PARTNER extends zio.aws.transfer.model.ProfileType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.ProfileType =
      software.amazon.awssdk.services.transfer.model.ProfileType.PARTNER
  }
}
