package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait SftpAuthenticationMethods {
  def unwrap
      : software.amazon.awssdk.services.transfer.model.SftpAuthenticationMethods
}
object SftpAuthenticationMethods {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.SftpAuthenticationMethods
  ): zio.aws.transfer.model.SftpAuthenticationMethods = value match {
    case software.amazon.awssdk.services.transfer.model.SftpAuthenticationMethods.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.SftpAuthenticationMethods.PASSWORD =>
      val r = PASSWORD
      r
    case software.amazon.awssdk.services.transfer.model.SftpAuthenticationMethods.PUBLIC_KEY =>
      val r = PUBLIC_KEY
      r
    case software.amazon.awssdk.services.transfer.model.SftpAuthenticationMethods.PUBLIC_KEY_OR_PASSWORD =>
      val r = PUBLIC_KEY_OR_PASSWORD
      r
    case software.amazon.awssdk.services.transfer.model.SftpAuthenticationMethods.PUBLIC_KEY_AND_PASSWORD =>
      val r = PUBLIC_KEY_AND_PASSWORD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transfer.model.SftpAuthenticationMethods {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.SftpAuthenticationMethods =
      software.amazon.awssdk.services.transfer.model.SftpAuthenticationMethods.UNKNOWN_TO_SDK_VERSION
  }
  case object PASSWORD
      extends zio.aws.transfer.model.SftpAuthenticationMethods {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.SftpAuthenticationMethods =
      software.amazon.awssdk.services.transfer.model.SftpAuthenticationMethods.PASSWORD
  }
  case object PUBLIC_KEY
      extends zio.aws.transfer.model.SftpAuthenticationMethods {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.SftpAuthenticationMethods =
      software.amazon.awssdk.services.transfer.model.SftpAuthenticationMethods.PUBLIC_KEY
  }
  case object PUBLIC_KEY_OR_PASSWORD
      extends zio.aws.transfer.model.SftpAuthenticationMethods {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.SftpAuthenticationMethods =
      software.amazon.awssdk.services.transfer.model.SftpAuthenticationMethods.PUBLIC_KEY_OR_PASSWORD
  }
  case object PUBLIC_KEY_AND_PASSWORD
      extends zio.aws.transfer.model.SftpAuthenticationMethods {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.SftpAuthenticationMethods =
      software.amazon.awssdk.services.transfer.model.SftpAuthenticationMethods.PUBLIC_KEY_AND_PASSWORD
  }
}
