package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.TransferId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartFileTransferResponse(transferId: TransferId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.StartFileTransferResponse = {
    import StartFileTransferResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.StartFileTransferResponse
      .builder()
      .transferId(TransferId.unwrap(transferId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.StartFileTransferResponse.ReadOnly =
    zio.aws.transfer.model.StartFileTransferResponse.wrap(buildAwsValue())
}
object StartFileTransferResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.StartFileTransferResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.StartFileTransferResponse =
      zio.aws.transfer.model.StartFileTransferResponse(transferId)
    def transferId: TransferId
    def getTransferId: ZIO[Any, Nothing, TransferId] = ZIO.succeed(transferId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.StartFileTransferResponse
  ) extends zio.aws.transfer.model.StartFileTransferResponse.ReadOnly {
    override val transferId: TransferId =
      zio.aws.transfer.model.primitives.TransferId(impl.transferId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.StartFileTransferResponse
  ): zio.aws.transfer.model.StartFileTransferResponse.ReadOnly = new Wrapper(
    impl
  )
}
