package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{
  ProfileId,
  ServerId,
  HomeDirectory,
  Description,
  AgreementId,
  Role
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAgreementRequest(
    agreementId: AgreementId,
    serverId: ServerId,
    description: Optional[Description] = Optional.Absent,
    status: Optional[zio.aws.transfer.model.AgreementStatusType] =
      Optional.Absent,
    localProfileId: Optional[ProfileId] = Optional.Absent,
    partnerProfileId: Optional[ProfileId] = Optional.Absent,
    baseDirectory: Optional[HomeDirectory] = Optional.Absent,
    accessRole: Optional[Role] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.UpdateAgreementRequest = {
    import UpdateAgreementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.UpdateAgreementRequest
      .builder()
      .agreementId(AgreementId.unwrap(agreementId): java.lang.String)
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        localProfileId.map(value => ProfileId.unwrap(value): java.lang.String)
      )(_.localProfileId)
      .optionallyWith(
        partnerProfileId.map(value => ProfileId.unwrap(value): java.lang.String)
      )(_.partnerProfileId)
      .optionallyWith(
        baseDirectory.map(value =>
          HomeDirectory.unwrap(value): java.lang.String
        )
      )(_.baseDirectory)
      .optionallyWith(
        accessRole.map(value => Role.unwrap(value): java.lang.String)
      )(_.accessRole)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.UpdateAgreementRequest.ReadOnly =
    zio.aws.transfer.model.UpdateAgreementRequest.wrap(buildAwsValue())
}
object UpdateAgreementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.UpdateAgreementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.UpdateAgreementRequest =
      zio.aws.transfer.model.UpdateAgreementRequest(
        agreementId,
        serverId,
        description.map(value => value),
        status.map(value => value),
        localProfileId.map(value => value),
        partnerProfileId.map(value => value),
        baseDirectory.map(value => value),
        accessRole.map(value => value)
      )
    def agreementId: AgreementId
    def serverId: ServerId
    def description: Optional[Description]
    def status: Optional[zio.aws.transfer.model.AgreementStatusType]
    def localProfileId: Optional[ProfileId]
    def partnerProfileId: Optional[ProfileId]
    def baseDirectory: Optional[HomeDirectory]
    def accessRole: Optional[Role]
    def getAgreementId: ZIO[Any, Nothing, AgreementId] =
      ZIO.succeed(agreementId)
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.transfer.model.AgreementStatusType] =
      AwsError.unwrapOptionField("status", status)
    def getLocalProfileId: ZIO[Any, AwsError, ProfileId] =
      AwsError.unwrapOptionField("localProfileId", localProfileId)
    def getPartnerProfileId: ZIO[Any, AwsError, ProfileId] =
      AwsError.unwrapOptionField("partnerProfileId", partnerProfileId)
    def getBaseDirectory: ZIO[Any, AwsError, HomeDirectory] =
      AwsError.unwrapOptionField("baseDirectory", baseDirectory)
    def getAccessRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("accessRole", accessRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.UpdateAgreementRequest
  ) extends zio.aws.transfer.model.UpdateAgreementRequest.ReadOnly {
    override val agreementId: AgreementId =
      zio.aws.transfer.model.primitives.AgreementId(impl.agreementId())
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.transfer.model.primitives.Description(value))
    override val status: Optional[zio.aws.transfer.model.AgreementStatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.transfer.model.AgreementStatusType.wrap(value))
    override val localProfileId: Optional[ProfileId] = zio.aws.core.internal
      .optionalFromNullable(impl.localProfileId())
      .map(value => zio.aws.transfer.model.primitives.ProfileId(value))
    override val partnerProfileId: Optional[ProfileId] = zio.aws.core.internal
      .optionalFromNullable(impl.partnerProfileId())
      .map(value => zio.aws.transfer.model.primitives.ProfileId(value))
    override val baseDirectory: Optional[HomeDirectory] = zio.aws.core.internal
      .optionalFromNullable(impl.baseDirectory())
      .map(value => zio.aws.transfer.model.primitives.HomeDirectory(value))
    override val accessRole: Optional[Role] = zio.aws.core.internal
      .optionalFromNullable(impl.accessRole())
      .map(value => zio.aws.transfer.model.primitives.Role(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.UpdateAgreementRequest
  ): zio.aws.transfer.model.UpdateAgreementRequest.ReadOnly = new Wrapper(impl)
}
