package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.AgreementId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateAgreementResponse(agreementId: AgreementId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.UpdateAgreementResponse = {
    import UpdateAgreementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.UpdateAgreementResponse
      .builder()
      .agreementId(AgreementId.unwrap(agreementId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.UpdateAgreementResponse.ReadOnly =
    zio.aws.transfer.model.UpdateAgreementResponse.wrap(buildAwsValue())
}
object UpdateAgreementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.UpdateAgreementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.UpdateAgreementResponse =
      zio.aws.transfer.model.UpdateAgreementResponse(agreementId)
    def agreementId: AgreementId
    def getAgreementId: ZIO[Any, Nothing, AgreementId] =
      ZIO.succeed(agreementId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.UpdateAgreementResponse
  ) extends zio.aws.transfer.model.UpdateAgreementResponse.ReadOnly {
    override val agreementId: AgreementId =
      zio.aws.transfer.model.primitives.AgreementId(impl.agreementId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.UpdateAgreementResponse
  ): zio.aws.transfer.model.UpdateAgreementResponse.ReadOnly = new Wrapper(impl)
}
