package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.ProfileId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateProfileResponse(profileId: ProfileId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.UpdateProfileResponse = {
    import UpdateProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.UpdateProfileResponse
      .builder()
      .profileId(ProfileId.unwrap(profileId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.UpdateProfileResponse.ReadOnly =
    zio.aws.transfer.model.UpdateProfileResponse.wrap(buildAwsValue())
}
object UpdateProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.UpdateProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.UpdateProfileResponse =
      zio.aws.transfer.model.UpdateProfileResponse(profileId)
    def profileId: ProfileId
    def getProfileId: ZIO[Any, Nothing, ProfileId] = ZIO.succeed(profileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.UpdateProfileResponse
  ) extends zio.aws.transfer.model.UpdateProfileResponse.ReadOnly {
    override val profileId: ProfileId =
      zio.aws.transfer.model.primitives.ProfileId(impl.profileId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.UpdateProfileResponse
  ): zio.aws.transfer.model.UpdateProfileResponse.ReadOnly = new Wrapper(impl)
}
