package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{
  Certificate,
  PostAuthenticationLoginBanner,
  ServerId,
  Arn,
  PreAuthenticationLoginBanner,
  NullableRole,
  SecurityPolicyName,
  HostKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateServerRequest(
    certificate: Optional[Certificate] = Optional.Absent,
    protocolDetails: Optional[zio.aws.transfer.model.ProtocolDetails] =
      Optional.Absent,
    endpointDetails: Optional[zio.aws.transfer.model.EndpointDetails] =
      Optional.Absent,
    endpointType: Optional[zio.aws.transfer.model.EndpointType] =
      Optional.Absent,
    hostKey: Optional[HostKey] = Optional.Absent,
    identityProviderDetails: Optional[
      zio.aws.transfer.model.IdentityProviderDetails
    ] = Optional.Absent,
    loggingRole: Optional[NullableRole] = Optional.Absent,
    postAuthenticationLoginBanner: Optional[PostAuthenticationLoginBanner] =
      Optional.Absent,
    preAuthenticationLoginBanner: Optional[PreAuthenticationLoginBanner] =
      Optional.Absent,
    protocols: Optional[Iterable[zio.aws.transfer.model.Protocol]] =
      Optional.Absent,
    securityPolicyName: Optional[SecurityPolicyName] = Optional.Absent,
    serverId: ServerId,
    workflowDetails: Optional[zio.aws.transfer.model.WorkflowDetails] =
      Optional.Absent,
    structuredLogDestinations: Optional[Iterable[Arn]] = Optional.Absent,
    s3StorageOptions: Optional[zio.aws.transfer.model.S3StorageOptions] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.UpdateServerRequest = {
    import UpdateServerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.UpdateServerRequest
      .builder()
      .optionallyWith(
        certificate.map(value => Certificate.unwrap(value): java.lang.String)
      )(_.certificate)
      .optionallyWith(protocolDetails.map(value => value.buildAwsValue()))(
        _.protocolDetails
      )
      .optionallyWith(endpointDetails.map(value => value.buildAwsValue()))(
        _.endpointDetails
      )
      .optionallyWith(endpointType.map(value => value.unwrap))(_.endpointType)
      .optionallyWith(
        hostKey.map(value => HostKey.unwrap(value): java.lang.String)
      )(_.hostKey)
      .optionallyWith(
        identityProviderDetails.map(value => value.buildAwsValue())
      )(_.identityProviderDetails)
      .optionallyWith(
        loggingRole.map(value => NullableRole.unwrap(value): java.lang.String)
      )(_.loggingRole)
      .optionallyWith(
        postAuthenticationLoginBanner.map(value =>
          PostAuthenticationLoginBanner.unwrap(value): java.lang.String
        )
      )(_.postAuthenticationLoginBanner)
      .optionallyWith(
        preAuthenticationLoginBanner.map(value =>
          PreAuthenticationLoginBanner.unwrap(value): java.lang.String
        )
      )(_.preAuthenticationLoginBanner)
      .optionallyWith(
        protocols.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.protocolsWithStrings)
      .optionallyWith(
        securityPolicyName.map(value =>
          SecurityPolicyName.unwrap(value): java.lang.String
        )
      )(_.securityPolicyName)
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .optionallyWith(workflowDetails.map(value => value.buildAwsValue()))(
        _.workflowDetails
      )
      .optionallyWith(
        structuredLogDestinations.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.structuredLogDestinations)
      .optionallyWith(s3StorageOptions.map(value => value.buildAwsValue()))(
        _.s3StorageOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.UpdateServerRequest.ReadOnly =
    zio.aws.transfer.model.UpdateServerRequest.wrap(buildAwsValue())
}
object UpdateServerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.UpdateServerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.UpdateServerRequest =
      zio.aws.transfer.model.UpdateServerRequest(
        certificate.map(value => value),
        protocolDetails.map(value => value.asEditable),
        endpointDetails.map(value => value.asEditable),
        endpointType.map(value => value),
        hostKey.map(value => value),
        identityProviderDetails.map(value => value.asEditable),
        loggingRole.map(value => value),
        postAuthenticationLoginBanner.map(value => value),
        preAuthenticationLoginBanner.map(value => value),
        protocols.map(value => value),
        securityPolicyName.map(value => value),
        serverId,
        workflowDetails.map(value => value.asEditable),
        structuredLogDestinations.map(value => value),
        s3StorageOptions.map(value => value.asEditable)
      )
    def certificate: Optional[Certificate]
    def protocolDetails
        : Optional[zio.aws.transfer.model.ProtocolDetails.ReadOnly]
    def endpointDetails
        : Optional[zio.aws.transfer.model.EndpointDetails.ReadOnly]
    def endpointType: Optional[zio.aws.transfer.model.EndpointType]
    def hostKey: Optional[HostKey]
    def identityProviderDetails
        : Optional[zio.aws.transfer.model.IdentityProviderDetails.ReadOnly]
    def loggingRole: Optional[NullableRole]
    def postAuthenticationLoginBanner: Optional[PostAuthenticationLoginBanner]
    def preAuthenticationLoginBanner: Optional[PreAuthenticationLoginBanner]
    def protocols: Optional[List[zio.aws.transfer.model.Protocol]]
    def securityPolicyName: Optional[SecurityPolicyName]
    def serverId: ServerId
    def workflowDetails
        : Optional[zio.aws.transfer.model.WorkflowDetails.ReadOnly]
    def structuredLogDestinations: Optional[List[Arn]]
    def s3StorageOptions
        : Optional[zio.aws.transfer.model.S3StorageOptions.ReadOnly]
    def getCertificate: ZIO[Any, AwsError, Certificate] =
      AwsError.unwrapOptionField("certificate", certificate)
    def getProtocolDetails
        : ZIO[Any, AwsError, zio.aws.transfer.model.ProtocolDetails.ReadOnly] =
      AwsError.unwrapOptionField("protocolDetails", protocolDetails)
    def getEndpointDetails
        : ZIO[Any, AwsError, zio.aws.transfer.model.EndpointDetails.ReadOnly] =
      AwsError.unwrapOptionField("endpointDetails", endpointDetails)
    def getEndpointType
        : ZIO[Any, AwsError, zio.aws.transfer.model.EndpointType] =
      AwsError.unwrapOptionField("endpointType", endpointType)
    def getHostKey: ZIO[Any, AwsError, HostKey] =
      AwsError.unwrapOptionField("hostKey", hostKey)
    def getIdentityProviderDetails: ZIO[
      Any,
      AwsError,
      zio.aws.transfer.model.IdentityProviderDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "identityProviderDetails",
      identityProviderDetails
    )
    def getLoggingRole: ZIO[Any, AwsError, NullableRole] =
      AwsError.unwrapOptionField("loggingRole", loggingRole)
    def getPostAuthenticationLoginBanner
        : ZIO[Any, AwsError, PostAuthenticationLoginBanner] =
      AwsError.unwrapOptionField(
        "postAuthenticationLoginBanner",
        postAuthenticationLoginBanner
      )
    def getPreAuthenticationLoginBanner
        : ZIO[Any, AwsError, PreAuthenticationLoginBanner] =
      AwsError.unwrapOptionField(
        "preAuthenticationLoginBanner",
        preAuthenticationLoginBanner
      )
    def getProtocols
        : ZIO[Any, AwsError, List[zio.aws.transfer.model.Protocol]] =
      AwsError.unwrapOptionField("protocols", protocols)
    def getSecurityPolicyName: ZIO[Any, AwsError, SecurityPolicyName] =
      AwsError.unwrapOptionField("securityPolicyName", securityPolicyName)
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getWorkflowDetails
        : ZIO[Any, AwsError, zio.aws.transfer.model.WorkflowDetails.ReadOnly] =
      AwsError.unwrapOptionField("workflowDetails", workflowDetails)
    def getStructuredLogDestinations: ZIO[Any, AwsError, List[Arn]] = AwsError
      .unwrapOptionField("structuredLogDestinations", structuredLogDestinations)
    def getS3StorageOptions
        : ZIO[Any, AwsError, zio.aws.transfer.model.S3StorageOptions.ReadOnly] =
      AwsError.unwrapOptionField("s3StorageOptions", s3StorageOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.UpdateServerRequest
  ) extends zio.aws.transfer.model.UpdateServerRequest.ReadOnly {
    override val certificate: Optional[Certificate] = zio.aws.core.internal
      .optionalFromNullable(impl.certificate())
      .map(value => zio.aws.transfer.model.primitives.Certificate(value))
    override val protocolDetails
        : Optional[zio.aws.transfer.model.ProtocolDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocolDetails())
        .map(value => zio.aws.transfer.model.ProtocolDetails.wrap(value))
    override val endpointDetails
        : Optional[zio.aws.transfer.model.EndpointDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointDetails())
        .map(value => zio.aws.transfer.model.EndpointDetails.wrap(value))
    override val endpointType: Optional[zio.aws.transfer.model.EndpointType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointType())
        .map(value => zio.aws.transfer.model.EndpointType.wrap(value))
    override val hostKey: Optional[HostKey] = zio.aws.core.internal
      .optionalFromNullable(impl.hostKey())
      .map(value => zio.aws.transfer.model.primitives.HostKey(value))
    override val identityProviderDetails
        : Optional[zio.aws.transfer.model.IdentityProviderDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityProviderDetails())
        .map(value =>
          zio.aws.transfer.model.IdentityProviderDetails.wrap(value)
        )
    override val loggingRole: Optional[NullableRole] = zio.aws.core.internal
      .optionalFromNullable(impl.loggingRole())
      .map(value => zio.aws.transfer.model.primitives.NullableRole(value))
    override val postAuthenticationLoginBanner
        : Optional[PostAuthenticationLoginBanner] = zio.aws.core.internal
      .optionalFromNullable(impl.postAuthenticationLoginBanner())
      .map(value =>
        zio.aws.transfer.model.primitives.PostAuthenticationLoginBanner(value)
      )
    override val preAuthenticationLoginBanner
        : Optional[PreAuthenticationLoginBanner] = zio.aws.core.internal
      .optionalFromNullable(impl.preAuthenticationLoginBanner())
      .map(value =>
        zio.aws.transfer.model.primitives.PreAuthenticationLoginBanner(value)
      )
    override val protocols: Optional[List[zio.aws.transfer.model.Protocol]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocols())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.Protocol.wrap(item)
          }.toList
        )
    override val securityPolicyName: Optional[SecurityPolicyName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityPolicyName())
        .map(value =>
          zio.aws.transfer.model.primitives.SecurityPolicyName(value)
        )
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val workflowDetails
        : Optional[zio.aws.transfer.model.WorkflowDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflowDetails())
        .map(value => zio.aws.transfer.model.WorkflowDetails.wrap(value))
    override val structuredLogDestinations: Optional[List[Arn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.structuredLogDestinations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.primitives.Arn(item)
          }.toList
        )
    override val s3StorageOptions
        : Optional[zio.aws.transfer.model.S3StorageOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3StorageOptions())
        .map(value => zio.aws.transfer.model.S3StorageOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.UpdateServerRequest
  ): zio.aws.transfer.model.UpdateServerRequest.ReadOnly = new Wrapper(impl)
}
