package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{
  ServerId,
  HomeDirectory,
  Policy,
  Role,
  UserName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateUserRequest(
    homeDirectory: Optional[HomeDirectory] = Optional.Absent,
    homeDirectoryType: Optional[zio.aws.transfer.model.HomeDirectoryType] =
      Optional.Absent,
    homeDirectoryMappings: Optional[
      Iterable[zio.aws.transfer.model.HomeDirectoryMapEntry]
    ] = Optional.Absent,
    policy: Optional[Policy] = Optional.Absent,
    posixProfile: Optional[zio.aws.transfer.model.PosixProfile] =
      Optional.Absent,
    role: Optional[Role] = Optional.Absent,
    serverId: ServerId,
    userName: UserName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.UpdateUserRequest = {
    import UpdateUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.UpdateUserRequest
      .builder()
      .optionallyWith(
        homeDirectory.map(value =>
          HomeDirectory.unwrap(value): java.lang.String
        )
      )(_.homeDirectory)
      .optionallyWith(homeDirectoryType.map(value => value.unwrap))(
        _.homeDirectoryType
      )
      .optionallyWith(
        homeDirectoryMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.homeDirectoryMappings)
      .optionallyWith(
        policy.map(value => Policy.unwrap(value): java.lang.String)
      )(_.policy)
      .optionallyWith(posixProfile.map(value => value.buildAwsValue()))(
        _.posixProfile
      )
      .optionallyWith(role.map(value => Role.unwrap(value): java.lang.String))(
        _.role
      )
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .userName(UserName.unwrap(userName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.UpdateUserRequest.ReadOnly =
    zio.aws.transfer.model.UpdateUserRequest.wrap(buildAwsValue())
}
object UpdateUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.UpdateUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.UpdateUserRequest =
      zio.aws.transfer.model.UpdateUserRequest(
        homeDirectory.map(value => value),
        homeDirectoryType.map(value => value),
        homeDirectoryMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        policy.map(value => value),
        posixProfile.map(value => value.asEditable),
        role.map(value => value),
        serverId,
        userName
      )
    def homeDirectory: Optional[HomeDirectory]
    def homeDirectoryType: Optional[zio.aws.transfer.model.HomeDirectoryType]
    def homeDirectoryMappings
        : Optional[List[zio.aws.transfer.model.HomeDirectoryMapEntry.ReadOnly]]
    def policy: Optional[Policy]
    def posixProfile: Optional[zio.aws.transfer.model.PosixProfile.ReadOnly]
    def role: Optional[Role]
    def serverId: ServerId
    def userName: UserName
    def getHomeDirectory: ZIO[Any, AwsError, HomeDirectory] =
      AwsError.unwrapOptionField("homeDirectory", homeDirectory)
    def getHomeDirectoryType
        : ZIO[Any, AwsError, zio.aws.transfer.model.HomeDirectoryType] =
      AwsError.unwrapOptionField("homeDirectoryType", homeDirectoryType)
    def getHomeDirectoryMappings: ZIO[Any, AwsError, List[
      zio.aws.transfer.model.HomeDirectoryMapEntry.ReadOnly
    ]] =
      AwsError.unwrapOptionField("homeDirectoryMappings", homeDirectoryMappings)
    def getPolicy: ZIO[Any, AwsError, Policy] =
      AwsError.unwrapOptionField("policy", policy)
    def getPosixProfile
        : ZIO[Any, AwsError, zio.aws.transfer.model.PosixProfile.ReadOnly] =
      AwsError.unwrapOptionField("posixProfile", posixProfile)
    def getRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("role", role)
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getUserName: ZIO[Any, Nothing, UserName] = ZIO.succeed(userName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.UpdateUserRequest
  ) extends zio.aws.transfer.model.UpdateUserRequest.ReadOnly {
    override val homeDirectory: Optional[HomeDirectory] = zio.aws.core.internal
      .optionalFromNullable(impl.homeDirectory())
      .map(value => zio.aws.transfer.model.primitives.HomeDirectory(value))
    override val homeDirectoryType
        : Optional[zio.aws.transfer.model.HomeDirectoryType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.homeDirectoryType())
        .map(value => zio.aws.transfer.model.HomeDirectoryType.wrap(value))
    override val homeDirectoryMappings: Optional[
      List[zio.aws.transfer.model.HomeDirectoryMapEntry.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.homeDirectoryMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transfer.model.HomeDirectoryMapEntry.wrap(item)
        }.toList
      )
    override val policy: Optional[Policy] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => zio.aws.transfer.model.primitives.Policy(value))
    override val posixProfile
        : Optional[zio.aws.transfer.model.PosixProfile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.posixProfile())
        .map(value => zio.aws.transfer.model.PosixProfile.wrap(value))
    override val role: Optional[Role] = zio.aws.core.internal
      .optionalFromNullable(impl.role())
      .map(value => zio.aws.transfer.model.primitives.Role(value))
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val userName: UserName =
      zio.aws.transfer.model.primitives.UserName(impl.userName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.UpdateUserRequest
  ): zio.aws.transfer.model.UpdateUserRequest.ReadOnly = new Wrapper(impl)
}
