package zio.aws.translate
import zio.aws.translate.model.TerminologyProperties.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.translate.model.{
  DeleteParallelDataRequest,
  TranslateTextRequest,
  GetParallelDataRequest,
  ListParallelDataRequest,
  UpdateParallelDataRequest,
  DescribeTextTranslationJobRequest,
  ListTerminologiesRequest,
  ImportTerminologyRequest,
  StartTextTranslationJobRequest,
  ListTextTranslationJobsRequest,
  DeleteTerminologyRequest,
  StopTextTranslationJobRequest,
  GetTerminologyRequest,
  CreateParallelDataRequest
}
import software.amazon.awssdk.services.translate.model.{
  ListTerminologiesResponse,
  StartTextTranslationJobResponse,
  TranslateTextResponse,
  DescribeTextTranslationJobResponse,
  GetParallelDataResponse,
  ListParallelDataResponse,
  StopTextTranslationJobResponse,
  ParallelDataProperties,
  DeleteParallelDataResponse,
  ListTextTranslationJobsResponse,
  DeleteTerminologyResponse,
  ImportTerminologyResponse,
  CreateParallelDataResponse,
  TerminologyProperties,
  UpdateParallelDataResponse,
  GetTerminologyResponse,
  TextTranslationJobProperties
}
import software.amazon.awssdk.services.translate.{
  TranslateAsyncClientBuilder,
  TranslateAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait Translate extends AspectSupport[Translate] {
  val api: TranslateAsyncClient
  def importTerminology(
      request: ImportTerminologyRequest
  ): IO[AwsError, zio.aws.translate.model.ImportTerminologyResponse.ReadOnly]
  def getTerminology(
      request: GetTerminologyRequest
  ): IO[AwsError, zio.aws.translate.model.GetTerminologyResponse.ReadOnly]
  def listParallelData(request: ListParallelDataRequest): ZStream[
    Any,
    AwsError,
    zio.aws.translate.model.ParallelDataProperties.ReadOnly
  ]
  def listParallelDataPaginated(
      request: ListParallelDataRequest
  ): IO[AwsError, zio.aws.translate.model.ListParallelDataResponse.ReadOnly]
  def createParallelData(
      request: CreateParallelDataRequest
  ): IO[AwsError, zio.aws.translate.model.CreateParallelDataResponse.ReadOnly]
  def deleteTerminology(request: DeleteTerminologyRequest): IO[AwsError, Unit]
  def getParallelData(
      request: GetParallelDataRequest
  ): IO[AwsError, zio.aws.translate.model.GetParallelDataResponse.ReadOnly]
  def translateText(
      request: TranslateTextRequest
  ): IO[AwsError, zio.aws.translate.model.TranslateTextResponse.ReadOnly]
  def describeTextTranslationJob(
      request: DescribeTextTranslationJobRequest
  ): IO[
    AwsError,
    zio.aws.translate.model.DescribeTextTranslationJobResponse.ReadOnly
  ]
  def updateParallelData(
      request: UpdateParallelDataRequest
  ): IO[AwsError, zio.aws.translate.model.UpdateParallelDataResponse.ReadOnly]
  def deleteParallelData(
      request: DeleteParallelDataRequest
  ): IO[AwsError, zio.aws.translate.model.DeleteParallelDataResponse.ReadOnly]
  def startTextTranslationJob(request: StartTextTranslationJobRequest): IO[
    AwsError,
    zio.aws.translate.model.StartTextTranslationJobResponse.ReadOnly
  ]
  def listTextTranslationJobs(request: ListTextTranslationJobsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.translate.model.TextTranslationJobProperties.ReadOnly
  ]
  def listTextTranslationJobsPaginated(
      request: ListTextTranslationJobsRequest
  ): IO[
    AwsError,
    zio.aws.translate.model.ListTextTranslationJobsResponse.ReadOnly
  ]
  def listTerminologies(
      request: ListTerminologiesRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listTerminologiesPaginated(
      request: ListTerminologiesRequest
  ): IO[AwsError, zio.aws.translate.model.ListTerminologiesResponse.ReadOnly]
  def stopTextTranslationJob(request: StopTextTranslationJobRequest): IO[
    AwsError,
    zio.aws.translate.model.StopTextTranslationJobResponse.ReadOnly
  ]
}
object Translate {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Translate] = customized(
    identity
  )
  def customized(
      customization: TranslateAsyncClientBuilder => TranslateAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Translate] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: TranslateAsyncClientBuilder => TranslateAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Translate] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = TranslateAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[TranslateAsyncClient, TranslateAsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[TranslateAsyncClient, TranslateAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new TranslateImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class TranslateImpl[R](
      override val api: TranslateAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Translate
      with AwsServiceBase[R] {
    override val serviceName: String = "Translate"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): TranslateImpl[R1] = new TranslateImpl(api, newAspect, r)
    def importTerminology(request: ImportTerminologyRequest): IO[
      AwsError,
      zio.aws.translate.model.ImportTerminologyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.translate.model.ImportTerminologyRequest,
      ImportTerminologyResponse
    ]("importTerminology", api.importTerminology)(request.buildAwsValue())
      .map(zio.aws.translate.model.ImportTerminologyResponse.wrap)
      .provideEnvironment(r)
    def getTerminology(
        request: GetTerminologyRequest
    ): IO[AwsError, zio.aws.translate.model.GetTerminologyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.translate.model.GetTerminologyRequest,
        GetTerminologyResponse
      ]("getTerminology", api.getTerminology)(request.buildAwsValue())
        .map(zio.aws.translate.model.GetTerminologyResponse.wrap)
        .provideEnvironment(r)
    def listParallelData(request: ListParallelDataRequest): ZStream[
      Any,
      AwsError,
      zio.aws.translate.model.ParallelDataProperties.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.translate.model.ListParallelDataRequest,
      ListParallelDataResponse,
      ParallelDataProperties
    ](
      "listParallelData",
      api.listParallelData,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.parallelDataPropertiesList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.translate.model.ParallelDataProperties.wrap(item))
      .provideEnvironment(r)
    def listParallelDataPaginated(
        request: ListParallelDataRequest
    ): IO[AwsError, zio.aws.translate.model.ListParallelDataResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.translate.model.ListParallelDataRequest,
        ListParallelDataResponse
      ]("listParallelData", api.listParallelData)(request.buildAwsValue())
        .map(zio.aws.translate.model.ListParallelDataResponse.wrap)
        .provideEnvironment(r)
    def createParallelData(request: CreateParallelDataRequest): IO[
      AwsError,
      zio.aws.translate.model.CreateParallelDataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.translate.model.CreateParallelDataRequest,
      CreateParallelDataResponse
    ]("createParallelData", api.createParallelData)(request.buildAwsValue())
      .map(zio.aws.translate.model.CreateParallelDataResponse.wrap)
      .provideEnvironment(r)
    def deleteTerminology(
        request: DeleteTerminologyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.translate.model.DeleteTerminologyRequest,
      DeleteTerminologyResponse
    ]("deleteTerminology", api.deleteTerminology)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def getParallelData(
        request: GetParallelDataRequest
    ): IO[AwsError, zio.aws.translate.model.GetParallelDataResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.translate.model.GetParallelDataRequest,
        GetParallelDataResponse
      ]("getParallelData", api.getParallelData)(request.buildAwsValue())
        .map(zio.aws.translate.model.GetParallelDataResponse.wrap)
        .provideEnvironment(r)
    def translateText(
        request: TranslateTextRequest
    ): IO[AwsError, zio.aws.translate.model.TranslateTextResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.translate.model.TranslateTextRequest,
        TranslateTextResponse
      ]("translateText", api.translateText)(request.buildAwsValue())
        .map(zio.aws.translate.model.TranslateTextResponse.wrap)
        .provideEnvironment(r)
    def describeTextTranslationJob(
        request: DescribeTextTranslationJobRequest
    ): IO[
      AwsError,
      zio.aws.translate.model.DescribeTextTranslationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.translate.model.DescribeTextTranslationJobRequest,
      DescribeTextTranslationJobResponse
    ]("describeTextTranslationJob", api.describeTextTranslationJob)(
      request.buildAwsValue()
    ).map(zio.aws.translate.model.DescribeTextTranslationJobResponse.wrap)
      .provideEnvironment(r)
    def updateParallelData(request: UpdateParallelDataRequest): IO[
      AwsError,
      zio.aws.translate.model.UpdateParallelDataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.translate.model.UpdateParallelDataRequest,
      UpdateParallelDataResponse
    ]("updateParallelData", api.updateParallelData)(request.buildAwsValue())
      .map(zio.aws.translate.model.UpdateParallelDataResponse.wrap)
      .provideEnvironment(r)
    def deleteParallelData(request: DeleteParallelDataRequest): IO[
      AwsError,
      zio.aws.translate.model.DeleteParallelDataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.translate.model.DeleteParallelDataRequest,
      DeleteParallelDataResponse
    ]("deleteParallelData", api.deleteParallelData)(request.buildAwsValue())
      .map(zio.aws.translate.model.DeleteParallelDataResponse.wrap)
      .provideEnvironment(r)
    def startTextTranslationJob(request: StartTextTranslationJobRequest): IO[
      AwsError,
      zio.aws.translate.model.StartTextTranslationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.translate.model.StartTextTranslationJobRequest,
      StartTextTranslationJobResponse
    ]("startTextTranslationJob", api.startTextTranslationJob)(
      request.buildAwsValue()
    ).map(zio.aws.translate.model.StartTextTranslationJobResponse.wrap)
      .provideEnvironment(r)
    def listTextTranslationJobs(
        request: ListTextTranslationJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.translate.model.TextTranslationJobProperties.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.translate.model.ListTextTranslationJobsRequest,
      ListTextTranslationJobsResponse,
      TextTranslationJobProperties
    ](
      "listTextTranslationJobs",
      api.listTextTranslationJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.textTranslationJobPropertiesList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.translate.model.TextTranslationJobProperties.wrap(item)
      )
      .provideEnvironment(r)
    def listTextTranslationJobsPaginated(
        request: ListTextTranslationJobsRequest
    ): IO[
      AwsError,
      zio.aws.translate.model.ListTextTranslationJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.translate.model.ListTextTranslationJobsRequest,
      ListTextTranslationJobsResponse
    ]("listTextTranslationJobs", api.listTextTranslationJobs)(
      request.buildAwsValue()
    ).map(zio.aws.translate.model.ListTextTranslationJobsResponse.wrap)
      .provideEnvironment(r)
    def listTerminologies(
        request: ListTerminologiesRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.translate.model.ListTerminologiesRequest,
      ListTerminologiesResponse,
      TerminologyProperties
    ](
      "listTerminologies",
      api.listTerminologies,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.terminologyPropertiesList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.translate.model.TerminologyProperties.wrap(item))
      .provideEnvironment(r)
    def listTerminologiesPaginated(request: ListTerminologiesRequest): IO[
      AwsError,
      zio.aws.translate.model.ListTerminologiesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.translate.model.ListTerminologiesRequest,
      ListTerminologiesResponse
    ]("listTerminologies", api.listTerminologies)(request.buildAwsValue())
      .map(zio.aws.translate.model.ListTerminologiesResponse.wrap)
      .provideEnvironment(r)
    def stopTextTranslationJob(request: StopTextTranslationJobRequest): IO[
      AwsError,
      zio.aws.translate.model.StopTextTranslationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.translate.model.StopTextTranslationJobRequest,
      StopTextTranslationJobResponse
    ]("stopTextTranslationJob", api.stopTextTranslationJob)(
      request.buildAwsValue()
    ).map(zio.aws.translate.model.StopTextTranslationJobResponse.wrap)
      .provideEnvironment(r)
  }
  def importTerminology(request: ImportTerminologyRequest): ZIO[
    zio.aws.translate.Translate,
    AwsError,
    zio.aws.translate.model.ImportTerminologyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importTerminology(request))
  def getTerminology(request: GetTerminologyRequest): ZIO[
    zio.aws.translate.Translate,
    AwsError,
    zio.aws.translate.model.GetTerminologyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTerminology(request))
  def listParallelData(request: ListParallelDataRequest): ZStream[
    zio.aws.translate.Translate,
    AwsError,
    zio.aws.translate.model.ParallelDataProperties.ReadOnly
  ] = ZStream.serviceWithStream(_.listParallelData(request))
  def listParallelDataPaginated(request: ListParallelDataRequest): ZIO[
    zio.aws.translate.Translate,
    AwsError,
    zio.aws.translate.model.ListParallelDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listParallelDataPaginated(request))
  def createParallelData(request: CreateParallelDataRequest): ZIO[
    zio.aws.translate.Translate,
    AwsError,
    zio.aws.translate.model.CreateParallelDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createParallelData(request))
  def deleteTerminology(
      request: DeleteTerminologyRequest
  ): ZIO[zio.aws.translate.Translate, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteTerminology(request))
  def getParallelData(request: GetParallelDataRequest): ZIO[
    zio.aws.translate.Translate,
    AwsError,
    zio.aws.translate.model.GetParallelDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getParallelData(request))
  def translateText(request: TranslateTextRequest): ZIO[
    zio.aws.translate.Translate,
    AwsError,
    zio.aws.translate.model.TranslateTextResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.translateText(request))
  def describeTextTranslationJob(
      request: DescribeTextTranslationJobRequest
  ): ZIO[
    zio.aws.translate.Translate,
    AwsError,
    zio.aws.translate.model.DescribeTextTranslationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTextTranslationJob(request))
  def updateParallelData(request: UpdateParallelDataRequest): ZIO[
    zio.aws.translate.Translate,
    AwsError,
    zio.aws.translate.model.UpdateParallelDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateParallelData(request))
  def deleteParallelData(request: DeleteParallelDataRequest): ZIO[
    zio.aws.translate.Translate,
    AwsError,
    zio.aws.translate.model.DeleteParallelDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteParallelData(request))
  def startTextTranslationJob(request: StartTextTranslationJobRequest): ZIO[
    zio.aws.translate.Translate,
    AwsError,
    zio.aws.translate.model.StartTextTranslationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startTextTranslationJob(request))
  def listTextTranslationJobs(request: ListTextTranslationJobsRequest): ZStream[
    zio.aws.translate.Translate,
    AwsError,
    zio.aws.translate.model.TextTranslationJobProperties.ReadOnly
  ] = ZStream.serviceWithStream(_.listTextTranslationJobs(request))
  def listTextTranslationJobsPaginated(
      request: ListTextTranslationJobsRequest
  ): ZIO[
    zio.aws.translate.Translate,
    AwsError,
    zio.aws.translate.model.ListTextTranslationJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTextTranslationJobsPaginated(request))
  def listTerminologies(
      request: ListTerminologiesRequest
  ): ZStream[zio.aws.translate.Translate, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.listTerminologies(request))
  def listTerminologiesPaginated(request: ListTerminologiesRequest): ZIO[
    zio.aws.translate.Translate,
    AwsError,
    zio.aws.translate.model.ListTerminologiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTerminologiesPaginated(request))
  def stopTextTranslationJob(request: StopTextTranslationJobRequest): ZIO[
    zio.aws.translate.Translate,
    AwsError,
    zio.aws.translate.model.StopTextTranslationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopTextTranslationJob(request))
}
