package zio.aws.translate
import zio.aws.translate.model.TerminologyProperties.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.translate.model.{
  DeleteParallelDataRequest,
  TranslateTextRequest,
  GetParallelDataRequest,
  ListParallelDataRequest,
  UpdateParallelDataRequest,
  DescribeTextTranslationJobRequest,
  ListTerminologiesRequest,
  ImportTerminologyRequest,
  StartTextTranslationJobRequest,
  ListTextTranslationJobsRequest,
  DeleteTerminologyRequest,
  StopTextTranslationJobRequest,
  GetTerminologyRequest,
  CreateParallelDataRequest
}
import software.amazon.awssdk.services.translate.TranslateAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object TranslateMock extends Mock[Translate] {
  object ImportTerminology
      extends Effect[
        ImportTerminologyRequest,
        AwsError,
        zio.aws.translate.model.ImportTerminologyResponse.ReadOnly
      ]
  object GetTerminology
      extends Effect[
        GetTerminologyRequest,
        AwsError,
        zio.aws.translate.model.GetTerminologyResponse.ReadOnly
      ]
  object ListParallelData
      extends Stream[
        ListParallelDataRequest,
        AwsError,
        zio.aws.translate.model.ParallelDataProperties.ReadOnly
      ]
  object ListParallelDataPaginated
      extends Effect[
        ListParallelDataRequest,
        AwsError,
        zio.aws.translate.model.ListParallelDataResponse.ReadOnly
      ]
  object CreateParallelData
      extends Effect[
        CreateParallelDataRequest,
        AwsError,
        zio.aws.translate.model.CreateParallelDataResponse.ReadOnly
      ]
  object DeleteTerminology
      extends Effect[DeleteTerminologyRequest, AwsError, Unit]
  object GetParallelData
      extends Effect[
        GetParallelDataRequest,
        AwsError,
        zio.aws.translate.model.GetParallelDataResponse.ReadOnly
      ]
  object TranslateText
      extends Effect[
        TranslateTextRequest,
        AwsError,
        zio.aws.translate.model.TranslateTextResponse.ReadOnly
      ]
  object DescribeTextTranslationJob
      extends Effect[
        DescribeTextTranslationJobRequest,
        AwsError,
        zio.aws.translate.model.DescribeTextTranslationJobResponse.ReadOnly
      ]
  object UpdateParallelData
      extends Effect[
        UpdateParallelDataRequest,
        AwsError,
        zio.aws.translate.model.UpdateParallelDataResponse.ReadOnly
      ]
  object DeleteParallelData
      extends Effect[
        DeleteParallelDataRequest,
        AwsError,
        zio.aws.translate.model.DeleteParallelDataResponse.ReadOnly
      ]
  object StartTextTranslationJob
      extends Effect[
        StartTextTranslationJobRequest,
        AwsError,
        zio.aws.translate.model.StartTextTranslationJobResponse.ReadOnly
      ]
  object ListTextTranslationJobs
      extends Stream[
        ListTextTranslationJobsRequest,
        AwsError,
        zio.aws.translate.model.TextTranslationJobProperties.ReadOnly
      ]
  object ListTextTranslationJobsPaginated
      extends Effect[
        ListTextTranslationJobsRequest,
        AwsError,
        zio.aws.translate.model.ListTextTranslationJobsResponse.ReadOnly
      ]
  object ListTerminologies
      extends Stream[ListTerminologiesRequest, AwsError, ReadOnly]
  object ListTerminologiesPaginated
      extends Effect[
        ListTerminologiesRequest,
        AwsError,
        zio.aws.translate.model.ListTerminologiesResponse.ReadOnly
      ]
  object StopTextTranslationJob
      extends Effect[
        StopTextTranslationJobRequest,
        AwsError,
        zio.aws.translate.model.StopTextTranslationJobResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Translate] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Translate {
          val api: TranslateAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Translate = this
          def importTerminology(request: ImportTerminologyRequest): IO[
            AwsError,
            zio.aws.translate.model.ImportTerminologyResponse.ReadOnly
          ] = proxy(ImportTerminology, request)
          def getTerminology(request: GetTerminologyRequest): IO[
            AwsError,
            zio.aws.translate.model.GetTerminologyResponse.ReadOnly
          ] = proxy(GetTerminology, request)
          def listParallelData(request: ListParallelDataRequest): ZStream[
            Any,
            AwsError,
            zio.aws.translate.model.ParallelDataProperties.ReadOnly
          ] = rts.unsafeRun(proxy(ListParallelData, request))
          def listParallelDataPaginated(request: ListParallelDataRequest): IO[
            AwsError,
            zio.aws.translate.model.ListParallelDataResponse.ReadOnly
          ] = proxy(ListParallelDataPaginated, request)
          def createParallelData(request: CreateParallelDataRequest): IO[
            AwsError,
            zio.aws.translate.model.CreateParallelDataResponse.ReadOnly
          ] = proxy(CreateParallelData, request)
          def deleteTerminology(
              request: DeleteTerminologyRequest
          ): IO[AwsError, Unit] = proxy(DeleteTerminology, request)
          def getParallelData(request: GetParallelDataRequest): IO[
            AwsError,
            zio.aws.translate.model.GetParallelDataResponse.ReadOnly
          ] = proxy(GetParallelData, request)
          def translateText(request: TranslateTextRequest): IO[
            AwsError,
            zio.aws.translate.model.TranslateTextResponse.ReadOnly
          ] = proxy(TranslateText, request)
          def describeTextTranslationJob(
              request: DescribeTextTranslationJobRequest
          ): IO[
            AwsError,
            zio.aws.translate.model.DescribeTextTranslationJobResponse.ReadOnly
          ] = proxy(DescribeTextTranslationJob, request)
          def updateParallelData(request: UpdateParallelDataRequest): IO[
            AwsError,
            zio.aws.translate.model.UpdateParallelDataResponse.ReadOnly
          ] = proxy(UpdateParallelData, request)
          def deleteParallelData(request: DeleteParallelDataRequest): IO[
            AwsError,
            zio.aws.translate.model.DeleteParallelDataResponse.ReadOnly
          ] = proxy(DeleteParallelData, request)
          def startTextTranslationJob(
              request: StartTextTranslationJobRequest
          ): IO[
            AwsError,
            zio.aws.translate.model.StartTextTranslationJobResponse.ReadOnly
          ] = proxy(StartTextTranslationJob, request)
          def listTextTranslationJobs(
              request: ListTextTranslationJobsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.translate.model.TextTranslationJobProperties.ReadOnly
          ] = rts.unsafeRun(proxy(ListTextTranslationJobs, request))
          def listTextTranslationJobsPaginated(
              request: ListTextTranslationJobsRequest
          ): IO[
            AwsError,
            zio.aws.translate.model.ListTextTranslationJobsResponse.ReadOnly
          ] = proxy(ListTextTranslationJobsPaginated, request)
          def listTerminologies(
              request: ListTerminologiesRequest
          ): ZStream[Any, AwsError, ReadOnly] =
            rts.unsafeRun(proxy(ListTerminologies, request))
          def listTerminologiesPaginated(request: ListTerminologiesRequest): IO[
            AwsError,
            zio.aws.translate.model.ListTerminologiesResponse.ReadOnly
          ] = proxy(ListTerminologiesPaginated, request)
          def stopTextTranslationJob(
              request: StopTextTranslationJobRequest
          ): IO[
            AwsError,
            zio.aws.translate.model.StopTextTranslationJobResponse.ReadOnly
          ] = proxy(StopTextTranslationJob, request)
        }
      }
    }
  }
}
