package zio.aws.translate.model
import zio.ZIO
import zio.aws.translate.model.primitives.ResourceName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AppliedTerminology(
    name: Optional[ResourceName] = Optional.Absent,
    terms: Optional[Iterable[zio.aws.translate.model.Term]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.AppliedTerminology = {
    import AppliedTerminology.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.AppliedTerminology
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        terms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.terms)
      .build()
  }
  def asReadOnly: zio.aws.translate.model.AppliedTerminology.ReadOnly =
    zio.aws.translate.model.AppliedTerminology.wrap(buildAwsValue())
}
object AppliedTerminology {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.AppliedTerminology
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.AppliedTerminology =
      zio.aws.translate.model.AppliedTerminology(
        name.map(value => value),
        terms.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Optional[ResourceName]
    def terms: Optional[List[zio.aws.translate.model.Term.ReadOnly]]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getTerms
        : ZIO[Any, AwsError, List[zio.aws.translate.model.Term.ReadOnly]] =
      AwsError.unwrapOptionField("terms", terms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.AppliedTerminology
  ) extends zio.aws.translate.model.AppliedTerminology.ReadOnly {
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.translate.model.primitives.ResourceName(value))
    override val terms: Optional[List[zio.aws.translate.model.Term.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.terms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.translate.model.Term.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.AppliedTerminology
  ): zio.aws.translate.model.AppliedTerminology.ReadOnly = new Wrapper(impl)
}
