package zio.aws.translate.model
import zio.ZIO
import zio.aws.translate.model.primitives.{
  ClientTokenString,
  Description,
  ResourceName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateParallelDataRequest(
    name: ResourceName,
    description: Optional[Description] = Optional.Absent,
    parallelDataConfig: zio.aws.translate.model.ParallelDataConfig,
    encryptionKey: Optional[zio.aws.translate.model.EncryptionKey] =
      Optional.Absent,
    clientToken: ClientTokenString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.CreateParallelDataRequest = {
    import CreateParallelDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.CreateParallelDataRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .parallelDataConfig(parallelDataConfig.buildAwsValue())
      .optionallyWith(encryptionKey.map(value => value.buildAwsValue()))(
        _.encryptionKey
      )
      .clientToken(ClientTokenString.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.translate.model.CreateParallelDataRequest.ReadOnly =
    zio.aws.translate.model.CreateParallelDataRequest.wrap(buildAwsValue())
}
object CreateParallelDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.CreateParallelDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.CreateParallelDataRequest =
      zio.aws.translate.model.CreateParallelDataRequest(
        name,
        description.map(value => value),
        parallelDataConfig.asEditable,
        encryptionKey.map(value => value.asEditable),
        clientToken
      )
    def name: ResourceName
    def description: Optional[Description]
    def parallelDataConfig: zio.aws.translate.model.ParallelDataConfig.ReadOnly
    def encryptionKey: Optional[zio.aws.translate.model.EncryptionKey.ReadOnly]
    def clientToken: ClientTokenString
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getParallelDataConfig: ZIO[
      Any,
      Nothing,
      zio.aws.translate.model.ParallelDataConfig.ReadOnly
    ] = ZIO.succeed(parallelDataConfig)
    def getEncryptionKey
        : ZIO[Any, AwsError, zio.aws.translate.model.EncryptionKey.ReadOnly] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
    def getClientToken: ZIO[Any, Nothing, ClientTokenString] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.CreateParallelDataRequest
  ) extends zio.aws.translate.model.CreateParallelDataRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.translate.model.primitives.ResourceName(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.translate.model.primitives.Description(value))
    override val parallelDataConfig
        : zio.aws.translate.model.ParallelDataConfig.ReadOnly =
      zio.aws.translate.model.ParallelDataConfig.wrap(impl.parallelDataConfig())
    override val encryptionKey
        : Optional[zio.aws.translate.model.EncryptionKey.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionKey())
        .map(value => zio.aws.translate.model.EncryptionKey.wrap(value))
    override val clientToken: ClientTokenString =
      zio.aws.translate.model.primitives.ClientTokenString(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.CreateParallelDataRequest
  ): zio.aws.translate.model.CreateParallelDataRequest.ReadOnly = new Wrapper(
    impl
  )
}
