package zio.aws.translate.model
import zio.ZIO
import zio.aws.translate.model.primitives.ResourceName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateParallelDataResponse(
    name: Optional[ResourceName] = Optional.Absent,
    status: Optional[zio.aws.translate.model.ParallelDataStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.CreateParallelDataResponse = {
    import CreateParallelDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.CreateParallelDataResponse
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.translate.model.CreateParallelDataResponse.ReadOnly =
    zio.aws.translate.model.CreateParallelDataResponse.wrap(buildAwsValue())
}
object CreateParallelDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.CreateParallelDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.CreateParallelDataResponse =
      zio.aws.translate.model.CreateParallelDataResponse(
        name.map(value => value),
        status.map(value => value)
      )
    def name: Optional[ResourceName]
    def status: Optional[zio.aws.translate.model.ParallelDataStatus]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.translate.model.ParallelDataStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.CreateParallelDataResponse
  ) extends zio.aws.translate.model.CreateParallelDataResponse.ReadOnly {
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.translate.model.primitives.ResourceName(value))
    override val status: Optional[zio.aws.translate.model.ParallelDataStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.translate.model.ParallelDataStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.CreateParallelDataResponse
  ): zio.aws.translate.model.CreateParallelDataResponse.ReadOnly = new Wrapper(
    impl
  )
}
