package zio.aws.translate.model
import zio.ZIO
import zio.aws.translate.model.primitives.ResourceName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteParallelDataRequest(name: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.DeleteParallelDataRequest = {
    import DeleteParallelDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.DeleteParallelDataRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.translate.model.DeleteParallelDataRequest.ReadOnly =
    zio.aws.translate.model.DeleteParallelDataRequest.wrap(buildAwsValue())
}
object DeleteParallelDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.DeleteParallelDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.DeleteParallelDataRequest =
      zio.aws.translate.model.DeleteParallelDataRequest(name)
    def name: ResourceName
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.DeleteParallelDataRequest
  ) extends zio.aws.translate.model.DeleteParallelDataRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.translate.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.DeleteParallelDataRequest
  ): zio.aws.translate.model.DeleteParallelDataRequest.ReadOnly = new Wrapper(
    impl
  )
}
