package zio.aws.translate.model
import zio.ZIO
import zio.aws.translate.model.primitives.ResourceName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteTerminologyRequest(name: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.DeleteTerminologyRequest = {
    import DeleteTerminologyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.DeleteTerminologyRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.translate.model.DeleteTerminologyRequest.ReadOnly =
    zio.aws.translate.model.DeleteTerminologyRequest.wrap(buildAwsValue())
}
object DeleteTerminologyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.DeleteTerminologyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.DeleteTerminologyRequest =
      zio.aws.translate.model.DeleteTerminologyRequest(name)
    def name: ResourceName
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.DeleteTerminologyRequest
  ) extends zio.aws.translate.model.DeleteTerminologyRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.translate.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.DeleteTerminologyRequest
  ): zio.aws.translate.model.DeleteTerminologyRequest.ReadOnly = new Wrapper(
    impl
  )
}
