package zio.aws.translate.model
import zio.ZIO
import zio.aws.translate.model.primitives.JobId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeTextTranslationJobRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.DescribeTextTranslationJobRequest = {
    import DescribeTextTranslationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.DescribeTextTranslationJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.translate.model.DescribeTextTranslationJobRequest.ReadOnly =
    zio.aws.translate.model.DescribeTextTranslationJobRequest
      .wrap(buildAwsValue())
}
object DescribeTextTranslationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.DescribeTextTranslationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.DescribeTextTranslationJobRequest =
      zio.aws.translate.model.DescribeTextTranslationJobRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.DescribeTextTranslationJobRequest
  ) extends zio.aws.translate.model.DescribeTextTranslationJobRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.translate.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.DescribeTextTranslationJobRequest
  ): zio.aws.translate.model.DescribeTextTranslationJobRequest.ReadOnly =
    new Wrapper(impl)
}
