package zio.aws.translate.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeTextTranslationJobResponse(
    textTranslationJobProperties: Optional[
      zio.aws.translate.model.TextTranslationJobProperties
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.DescribeTextTranslationJobResponse = {
    import DescribeTextTranslationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.DescribeTextTranslationJobResponse
      .builder()
      .optionallyWith(
        textTranslationJobProperties.map(value => value.buildAwsValue())
      )(_.textTranslationJobProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.translate.model.DescribeTextTranslationJobResponse.ReadOnly =
    zio.aws.translate.model.DescribeTextTranslationJobResponse
      .wrap(buildAwsValue())
}
object DescribeTextTranslationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.DescribeTextTranslationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.DescribeTextTranslationJobResponse =
      zio.aws.translate.model.DescribeTextTranslationJobResponse(
        textTranslationJobProperties.map(value => value.asEditable)
      )
    def textTranslationJobProperties: Optional[
      zio.aws.translate.model.TextTranslationJobProperties.ReadOnly
    ]
    def getTextTranslationJobProperties: ZIO[
      Any,
      AwsError,
      zio.aws.translate.model.TextTranslationJobProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "textTranslationJobProperties",
      textTranslationJobProperties
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.DescribeTextTranslationJobResponse
  ) extends zio.aws.translate.model.DescribeTextTranslationJobResponse.ReadOnly {
    override val textTranslationJobProperties: Optional[
      zio.aws.translate.model.TextTranslationJobProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.textTranslationJobProperties())
      .map(value =>
        zio.aws.translate.model.TextTranslationJobProperties.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.DescribeTextTranslationJobResponse
  ): zio.aws.translate.model.DescribeTextTranslationJobResponse.ReadOnly =
    new Wrapper(impl)
}
