package zio.aws.translate.model
import scala.jdk.CollectionConverters.*
sealed trait Directionality {
  def unwrap: software.amazon.awssdk.services.translate.model.Directionality
}
object Directionality {
  def wrap(
      value: software.amazon.awssdk.services.translate.model.Directionality
  ): zio.aws.translate.model.Directionality = value match {
    case software.amazon.awssdk.services.translate.model.Directionality.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.translate.model.Directionality.UNI =>
      val r = UNI
      r
    case software.amazon.awssdk.services.translate.model.Directionality.MULTI =>
      val r = MULTI
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.translate.model.Directionality {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.Directionality =
      software.amazon.awssdk.services.translate.model.Directionality.UNKNOWN_TO_SDK_VERSION
  }
  case object UNI extends zio.aws.translate.model.Directionality {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.Directionality =
      software.amazon.awssdk.services.translate.model.Directionality.UNI
  }
  case object MULTI extends zio.aws.translate.model.Directionality {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.Directionality =
      software.amazon.awssdk.services.translate.model.Directionality.MULTI
  }
}
