package zio.aws.translate.model
import scala.jdk.CollectionConverters.*
sealed trait EncryptionKeyType {
  def unwrap: software.amazon.awssdk.services.translate.model.EncryptionKeyType
}
object EncryptionKeyType {
  def wrap(
      value: software.amazon.awssdk.services.translate.model.EncryptionKeyType
  ): zio.aws.translate.model.EncryptionKeyType = value match {
    case software.amazon.awssdk.services.translate.model.EncryptionKeyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.translate.model.EncryptionKeyType.KMS =>
      val r = KMS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.translate.model.EncryptionKeyType {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.EncryptionKeyType =
      software.amazon.awssdk.services.translate.model.EncryptionKeyType.UNKNOWN_TO_SDK_VERSION
  }
  case object KMS extends zio.aws.translate.model.EncryptionKeyType {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.EncryptionKeyType =
      software.amazon.awssdk.services.translate.model.EncryptionKeyType.KMS
  }
}
