package zio.aws.translate.model
import scala.jdk.CollectionConverters.*
sealed trait Formality {
  def unwrap: software.amazon.awssdk.services.translate.model.Formality
}
object Formality {
  def wrap(
      value: software.amazon.awssdk.services.translate.model.Formality
  ): zio.aws.translate.model.Formality = value match {
    case software.amazon.awssdk.services.translate.model.Formality.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.translate.model.Formality.FORMAL =>
      val r = FORMAL
      r
    case software.amazon.awssdk.services.translate.model.Formality.INFORMAL =>
      val r = INFORMAL
      r
  }
  case object unknownToSdkVersion extends zio.aws.translate.model.Formality {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.Formality =
      software.amazon.awssdk.services.translate.model.Formality.UNKNOWN_TO_SDK_VERSION
  }
  case object FORMAL extends zio.aws.translate.model.Formality {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.Formality =
      software.amazon.awssdk.services.translate.model.Formality.FORMAL
  }
  case object INFORMAL extends zio.aws.translate.model.Formality {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.Formality =
      software.amazon.awssdk.services.translate.model.Formality.INFORMAL
  }
}
