package zio.aws.translate.model
import zio.ZIO
import zio.aws.translate.model.primitives.ResourceName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetParallelDataRequest(name: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.GetParallelDataRequest = {
    import GetParallelDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.GetParallelDataRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.translate.model.GetParallelDataRequest.ReadOnly =
    zio.aws.translate.model.GetParallelDataRequest.wrap(buildAwsValue())
}
object GetParallelDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.GetParallelDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.GetParallelDataRequest =
      zio.aws.translate.model.GetParallelDataRequest(name)
    def name: ResourceName
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.GetParallelDataRequest
  ) extends zio.aws.translate.model.GetParallelDataRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.translate.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.GetParallelDataRequest
  ): zio.aws.translate.model.GetParallelDataRequest.ReadOnly = new Wrapper(impl)
}
