package zio.aws.translate.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetParallelDataResponse(
    parallelDataProperties: Optional[
      zio.aws.translate.model.ParallelDataProperties
    ] = Optional.Absent,
    dataLocation: Optional[zio.aws.translate.model.ParallelDataDataLocation] =
      Optional.Absent,
    auxiliaryDataLocation: Optional[
      zio.aws.translate.model.ParallelDataDataLocation
    ] = Optional.Absent,
    latestUpdateAttemptAuxiliaryDataLocation: Optional[
      zio.aws.translate.model.ParallelDataDataLocation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.GetParallelDataResponse = {
    import GetParallelDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.GetParallelDataResponse
      .builder()
      .optionallyWith(
        parallelDataProperties.map(value => value.buildAwsValue())
      )(_.parallelDataProperties)
      .optionallyWith(dataLocation.map(value => value.buildAwsValue()))(
        _.dataLocation
      )
      .optionallyWith(
        auxiliaryDataLocation.map(value => value.buildAwsValue())
      )(_.auxiliaryDataLocation)
      .optionallyWith(
        latestUpdateAttemptAuxiliaryDataLocation.map(value =>
          value.buildAwsValue()
        )
      )(_.latestUpdateAttemptAuxiliaryDataLocation)
      .build()
  }
  def asReadOnly: zio.aws.translate.model.GetParallelDataResponse.ReadOnly =
    zio.aws.translate.model.GetParallelDataResponse.wrap(buildAwsValue())
}
object GetParallelDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.GetParallelDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.GetParallelDataResponse =
      zio.aws.translate.model.GetParallelDataResponse(
        parallelDataProperties.map(value => value.asEditable),
        dataLocation.map(value => value.asEditable),
        auxiliaryDataLocation.map(value => value.asEditable),
        latestUpdateAttemptAuxiliaryDataLocation.map(value => value.asEditable)
      )
    def parallelDataProperties
        : Optional[zio.aws.translate.model.ParallelDataProperties.ReadOnly]
    def dataLocation
        : Optional[zio.aws.translate.model.ParallelDataDataLocation.ReadOnly]
    def auxiliaryDataLocation
        : Optional[zio.aws.translate.model.ParallelDataDataLocation.ReadOnly]
    def latestUpdateAttemptAuxiliaryDataLocation
        : Optional[zio.aws.translate.model.ParallelDataDataLocation.ReadOnly]
    def getParallelDataProperties: ZIO[
      Any,
      AwsError,
      zio.aws.translate.model.ParallelDataProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "parallelDataProperties",
      parallelDataProperties
    )
    def getDataLocation: ZIO[
      Any,
      AwsError,
      zio.aws.translate.model.ParallelDataDataLocation.ReadOnly
    ] = AwsError.unwrapOptionField("dataLocation", dataLocation)
    def getAuxiliaryDataLocation: ZIO[
      Any,
      AwsError,
      zio.aws.translate.model.ParallelDataDataLocation.ReadOnly
    ] =
      AwsError.unwrapOptionField("auxiliaryDataLocation", auxiliaryDataLocation)
    def getLatestUpdateAttemptAuxiliaryDataLocation: ZIO[
      Any,
      AwsError,
      zio.aws.translate.model.ParallelDataDataLocation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "latestUpdateAttemptAuxiliaryDataLocation",
      latestUpdateAttemptAuxiliaryDataLocation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.GetParallelDataResponse
  ) extends zio.aws.translate.model.GetParallelDataResponse.ReadOnly {
    override val parallelDataProperties
        : Optional[zio.aws.translate.model.ParallelDataProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parallelDataProperties())
        .map(value =>
          zio.aws.translate.model.ParallelDataProperties.wrap(value)
        )
    override val dataLocation
        : Optional[zio.aws.translate.model.ParallelDataDataLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataLocation())
        .map(value =>
          zio.aws.translate.model.ParallelDataDataLocation.wrap(value)
        )
    override val auxiliaryDataLocation
        : Optional[zio.aws.translate.model.ParallelDataDataLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.auxiliaryDataLocation())
        .map(value =>
          zio.aws.translate.model.ParallelDataDataLocation.wrap(value)
        )
    override val latestUpdateAttemptAuxiliaryDataLocation
        : Optional[zio.aws.translate.model.ParallelDataDataLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestUpdateAttemptAuxiliaryDataLocation())
        .map(value =>
          zio.aws.translate.model.ParallelDataDataLocation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.GetParallelDataResponse
  ): zio.aws.translate.model.GetParallelDataResponse.ReadOnly = new Wrapper(
    impl
  )
}
