package zio.aws.translate.model
import zio.ZIO
import zio.aws.translate.model.primitives.ResourceName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetTerminologyRequest(
    name: ResourceName,
    terminologyDataFormat: Optional[
      zio.aws.translate.model.TerminologyDataFormat
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.GetTerminologyRequest = {
    import GetTerminologyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.GetTerminologyRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(terminologyDataFormat.map(value => value.unwrap))(
        _.terminologyDataFormat
      )
      .build()
  }
  def asReadOnly: zio.aws.translate.model.GetTerminologyRequest.ReadOnly =
    zio.aws.translate.model.GetTerminologyRequest.wrap(buildAwsValue())
}
object GetTerminologyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.GetTerminologyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.GetTerminologyRequest =
      zio.aws.translate.model
        .GetTerminologyRequest(name, terminologyDataFormat.map(value => value))
    def name: ResourceName
    def terminologyDataFormat
        : Optional[zio.aws.translate.model.TerminologyDataFormat]
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getTerminologyDataFormat
        : ZIO[Any, AwsError, zio.aws.translate.model.TerminologyDataFormat] =
      AwsError.unwrapOptionField("terminologyDataFormat", terminologyDataFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.GetTerminologyRequest
  ) extends zio.aws.translate.model.GetTerminologyRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.translate.model.primitives.ResourceName(impl.name())
    override val terminologyDataFormat
        : Optional[zio.aws.translate.model.TerminologyDataFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.terminologyDataFormat())
        .map(value => zio.aws.translate.model.TerminologyDataFormat.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.GetTerminologyRequest
  ): zio.aws.translate.model.GetTerminologyRequest.ReadOnly = new Wrapper(impl)
}
