package zio.aws.translate.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetTerminologyResponse(
    terminologyProperties: Optional[
      zio.aws.translate.model.TerminologyProperties
    ] = Optional.Absent,
    terminologyDataLocation: Optional[
      zio.aws.translate.model.TerminologyDataLocation
    ] = Optional.Absent,
    auxiliaryDataLocation: Optional[
      zio.aws.translate.model.TerminologyDataLocation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.GetTerminologyResponse = {
    import GetTerminologyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.GetTerminologyResponse
      .builder()
      .optionallyWith(
        terminologyProperties.map(value => value.buildAwsValue())
      )(_.terminologyProperties)
      .optionallyWith(
        terminologyDataLocation.map(value => value.buildAwsValue())
      )(_.terminologyDataLocation)
      .optionallyWith(
        auxiliaryDataLocation.map(value => value.buildAwsValue())
      )(_.auxiliaryDataLocation)
      .build()
  }
  def asReadOnly: zio.aws.translate.model.GetTerminologyResponse.ReadOnly =
    zio.aws.translate.model.GetTerminologyResponse.wrap(buildAwsValue())
}
object GetTerminologyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.GetTerminologyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.GetTerminologyResponse =
      zio.aws.translate.model.GetTerminologyResponse(
        terminologyProperties.map(value => value.asEditable),
        terminologyDataLocation.map(value => value.asEditable),
        auxiliaryDataLocation.map(value => value.asEditable)
      )
    def terminologyProperties
        : Optional[zio.aws.translate.model.TerminologyProperties.ReadOnly]
    def terminologyDataLocation
        : Optional[zio.aws.translate.model.TerminologyDataLocation.ReadOnly]
    def auxiliaryDataLocation
        : Optional[zio.aws.translate.model.TerminologyDataLocation.ReadOnly]
    def getTerminologyProperties: ZIO[
      Any,
      AwsError,
      zio.aws.translate.model.TerminologyProperties.ReadOnly
    ] =
      AwsError.unwrapOptionField("terminologyProperties", terminologyProperties)
    def getTerminologyDataLocation: ZIO[
      Any,
      AwsError,
      zio.aws.translate.model.TerminologyDataLocation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "terminologyDataLocation",
      terminologyDataLocation
    )
    def getAuxiliaryDataLocation: ZIO[
      Any,
      AwsError,
      zio.aws.translate.model.TerminologyDataLocation.ReadOnly
    ] =
      AwsError.unwrapOptionField("auxiliaryDataLocation", auxiliaryDataLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.GetTerminologyResponse
  ) extends zio.aws.translate.model.GetTerminologyResponse.ReadOnly {
    override val terminologyProperties
        : Optional[zio.aws.translate.model.TerminologyProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.terminologyProperties())
        .map(value => zio.aws.translate.model.TerminologyProperties.wrap(value))
    override val terminologyDataLocation
        : Optional[zio.aws.translate.model.TerminologyDataLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.terminologyDataLocation())
        .map(value =>
          zio.aws.translate.model.TerminologyDataLocation.wrap(value)
        )
    override val auxiliaryDataLocation
        : Optional[zio.aws.translate.model.TerminologyDataLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.auxiliaryDataLocation())
        .map(value =>
          zio.aws.translate.model.TerminologyDataLocation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.GetTerminologyResponse
  ): zio.aws.translate.model.GetTerminologyResponse.ReadOnly = new Wrapper(impl)
}
