package zio.aws.translate.model
import zio.ZIO
import zio.aws.translate.model.primitives.{Description, ResourceName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImportTerminologyRequest(
    name: ResourceName,
    mergeStrategy: zio.aws.translate.model.MergeStrategy,
    description: Optional[Description] = Optional.Absent,
    terminologyData: zio.aws.translate.model.TerminologyData,
    encryptionKey: Optional[zio.aws.translate.model.EncryptionKey] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.ImportTerminologyRequest = {
    import ImportTerminologyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.ImportTerminologyRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .mergeStrategy(mergeStrategy.unwrap)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .terminologyData(terminologyData.buildAwsValue())
      .optionallyWith(encryptionKey.map(value => value.buildAwsValue()))(
        _.encryptionKey
      )
      .build()
  }
  def asReadOnly: zio.aws.translate.model.ImportTerminologyRequest.ReadOnly =
    zio.aws.translate.model.ImportTerminologyRequest.wrap(buildAwsValue())
}
object ImportTerminologyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.ImportTerminologyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.ImportTerminologyRequest =
      zio.aws.translate.model.ImportTerminologyRequest(
        name,
        mergeStrategy,
        description.map(value => value),
        terminologyData.asEditable,
        encryptionKey.map(value => value.asEditable)
      )
    def name: ResourceName
    def mergeStrategy: zio.aws.translate.model.MergeStrategy
    def description: Optional[Description]
    def terminologyData: zio.aws.translate.model.TerminologyData.ReadOnly
    def encryptionKey: Optional[zio.aws.translate.model.EncryptionKey.ReadOnly]
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getMergeStrategy
        : ZIO[Any, Nothing, zio.aws.translate.model.MergeStrategy] =
      ZIO.succeed(mergeStrategy)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getTerminologyData
        : ZIO[Any, Nothing, zio.aws.translate.model.TerminologyData.ReadOnly] =
      ZIO.succeed(terminologyData)
    def getEncryptionKey
        : ZIO[Any, AwsError, zio.aws.translate.model.EncryptionKey.ReadOnly] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.ImportTerminologyRequest
  ) extends zio.aws.translate.model.ImportTerminologyRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.translate.model.primitives.ResourceName(impl.name())
    override val mergeStrategy: zio.aws.translate.model.MergeStrategy =
      zio.aws.translate.model.MergeStrategy.wrap(impl.mergeStrategy())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.translate.model.primitives.Description(value))
    override val terminologyData
        : zio.aws.translate.model.TerminologyData.ReadOnly =
      zio.aws.translate.model.TerminologyData.wrap(impl.terminologyData())
    override val encryptionKey
        : Optional[zio.aws.translate.model.EncryptionKey.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionKey())
        .map(value => zio.aws.translate.model.EncryptionKey.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.ImportTerminologyRequest
  ): zio.aws.translate.model.ImportTerminologyRequest.ReadOnly = new Wrapper(
    impl
  )
}
