package zio.aws.translate.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImportTerminologyResponse(
    terminologyProperties: Optional[
      zio.aws.translate.model.TerminologyProperties
    ] = Optional.Absent,
    auxiliaryDataLocation: Optional[
      zio.aws.translate.model.TerminologyDataLocation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.ImportTerminologyResponse = {
    import ImportTerminologyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.ImportTerminologyResponse
      .builder()
      .optionallyWith(
        terminologyProperties.map(value => value.buildAwsValue())
      )(_.terminologyProperties)
      .optionallyWith(
        auxiliaryDataLocation.map(value => value.buildAwsValue())
      )(_.auxiliaryDataLocation)
      .build()
  }
  def asReadOnly: zio.aws.translate.model.ImportTerminologyResponse.ReadOnly =
    zio.aws.translate.model.ImportTerminologyResponse.wrap(buildAwsValue())
}
object ImportTerminologyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.ImportTerminologyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.ImportTerminologyResponse =
      zio.aws.translate.model.ImportTerminologyResponse(
        terminologyProperties.map(value => value.asEditable),
        auxiliaryDataLocation.map(value => value.asEditable)
      )
    def terminologyProperties
        : Optional[zio.aws.translate.model.TerminologyProperties.ReadOnly]
    def auxiliaryDataLocation
        : Optional[zio.aws.translate.model.TerminologyDataLocation.ReadOnly]
    def getTerminologyProperties: ZIO[
      Any,
      AwsError,
      zio.aws.translate.model.TerminologyProperties.ReadOnly
    ] =
      AwsError.unwrapOptionField("terminologyProperties", terminologyProperties)
    def getAuxiliaryDataLocation: ZIO[
      Any,
      AwsError,
      zio.aws.translate.model.TerminologyDataLocation.ReadOnly
    ] =
      AwsError.unwrapOptionField("auxiliaryDataLocation", auxiliaryDataLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.ImportTerminologyResponse
  ) extends zio.aws.translate.model.ImportTerminologyResponse.ReadOnly {
    override val terminologyProperties
        : Optional[zio.aws.translate.model.TerminologyProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.terminologyProperties())
        .map(value => zio.aws.translate.model.TerminologyProperties.wrap(value))
    override val auxiliaryDataLocation
        : Optional[zio.aws.translate.model.TerminologyDataLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.auxiliaryDataLocation())
        .map(value =>
          zio.aws.translate.model.TerminologyDataLocation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.ImportTerminologyResponse
  ): zio.aws.translate.model.ImportTerminologyResponse.ReadOnly = new Wrapper(
    impl
  )
}
