package zio.aws.translate.model
import zio.ZIO
import zio.aws.translate.model.primitives.{ContentType, S3Uri}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class InputDataConfig(s3Uri: S3Uri, contentType: ContentType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.InputDataConfig = {
    import InputDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.InputDataConfig
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .contentType(ContentType.unwrap(contentType): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.translate.model.InputDataConfig.ReadOnly =
    zio.aws.translate.model.InputDataConfig.wrap(buildAwsValue())
}
object InputDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.InputDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.InputDataConfig =
      zio.aws.translate.model.InputDataConfig(s3Uri, contentType)
    def s3Uri: S3Uri
    def contentType: ContentType
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
    def getContentType: ZIO[Any, Nothing, ContentType] =
      ZIO.succeed(contentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.InputDataConfig
  ) extends zio.aws.translate.model.InputDataConfig.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.translate.model.primitives.S3Uri(impl.s3Uri())
    override val contentType: ContentType =
      zio.aws.translate.model.primitives.ContentType(impl.contentType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.InputDataConfig
  ): zio.aws.translate.model.InputDataConfig.ReadOnly = new Wrapper(impl)
}
