package zio.aws.translate.model
import zio.ZIO
import zio.aws.translate.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class JobDetails(
    translatedDocumentsCount: Optional[Integer] = Optional.Absent,
    documentsWithErrorsCount: Optional[Integer] = Optional.Absent,
    inputDocumentsCount: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.JobDetails = {
    import JobDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.JobDetails
      .builder()
      .optionallyWith(
        translatedDocumentsCount.map(value => value: java.lang.Integer)
      )(_.translatedDocumentsCount)
      .optionallyWith(
        documentsWithErrorsCount.map(value => value: java.lang.Integer)
      )(_.documentsWithErrorsCount)
      .optionallyWith(
        inputDocumentsCount.map(value => value: java.lang.Integer)
      )(_.inputDocumentsCount)
      .build()
  }
  def asReadOnly: zio.aws.translate.model.JobDetails.ReadOnly =
    zio.aws.translate.model.JobDetails.wrap(buildAwsValue())
}
object JobDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.JobDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.JobDetails =
      zio.aws.translate.model.JobDetails(
        translatedDocumentsCount.map(value => value),
        documentsWithErrorsCount.map(value => value),
        inputDocumentsCount.map(value => value)
      )
    def translatedDocumentsCount: Optional[Integer]
    def documentsWithErrorsCount: Optional[Integer]
    def inputDocumentsCount: Optional[Integer]
    def getTranslatedDocumentsCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("translatedDocumentsCount", translatedDocumentsCount)
    def getDocumentsWithErrorsCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("documentsWithErrorsCount", documentsWithErrorsCount)
    def getInputDocumentsCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("inputDocumentsCount", inputDocumentsCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.JobDetails
  ) extends zio.aws.translate.model.JobDetails.ReadOnly {
    override val translatedDocumentsCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.translatedDocumentsCount())
        .map(value => value: Integer)
    override val documentsWithErrorsCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentsWithErrorsCount())
        .map(value => value: Integer)
    override val inputDocumentsCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.inputDocumentsCount())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.JobDetails
  ): zio.aws.translate.model.JobDetails.ReadOnly = new Wrapper(impl)
}
