package zio.aws.translate.model
import scala.jdk.CollectionConverters.*
sealed trait JobStatus {
  def unwrap: software.amazon.awssdk.services.translate.model.JobStatus
}
object JobStatus {
  def wrap(
      value: software.amazon.awssdk.services.translate.model.JobStatus
  ): zio.aws.translate.model.JobStatus = value match {
    case software.amazon.awssdk.services.translate.model.JobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.translate.model.JobStatus.SUBMITTED =>
      val r = SUBMITTED
      r
    case software.amazon.awssdk.services.translate.model.JobStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.translate.model.JobStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.translate.model.JobStatus.COMPLETED_WITH_ERROR =>
      val r = COMPLETED_WITH_ERROR
      r
    case software.amazon.awssdk.services.translate.model.JobStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.translate.model.JobStatus.STOP_REQUESTED =>
      val r = STOP_REQUESTED
      r
    case software.amazon.awssdk.services.translate.model.JobStatus.STOPPED =>
      val r = STOPPED
      r
  }
  case object unknownToSdkVersion extends zio.aws.translate.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.JobStatus =
      software.amazon.awssdk.services.translate.model.JobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object SUBMITTED extends zio.aws.translate.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.JobStatus =
      software.amazon.awssdk.services.translate.model.JobStatus.SUBMITTED
  }
  case object IN_PROGRESS extends zio.aws.translate.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.JobStatus =
      software.amazon.awssdk.services.translate.model.JobStatus.IN_PROGRESS
  }
  case object COMPLETED extends zio.aws.translate.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.JobStatus =
      software.amazon.awssdk.services.translate.model.JobStatus.COMPLETED
  }
  case object COMPLETED_WITH_ERROR extends zio.aws.translate.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.JobStatus =
      software.amazon.awssdk.services.translate.model.JobStatus.COMPLETED_WITH_ERROR
  }
  case object FAILED extends zio.aws.translate.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.JobStatus =
      software.amazon.awssdk.services.translate.model.JobStatus.FAILED
  }
  case object STOP_REQUESTED extends zio.aws.translate.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.JobStatus =
      software.amazon.awssdk.services.translate.model.JobStatus.STOP_REQUESTED
  }
  case object STOPPED extends zio.aws.translate.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.JobStatus =
      software.amazon.awssdk.services.translate.model.JobStatus.STOPPED
  }
}
