package zio.aws.translate.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.translate.model.primitives.{MaxResultsInteger, NextToken}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListParallelDataRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResultsInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.ListParallelDataRequest = {
    import ListParallelDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.ListParallelDataRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResultsInteger.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.translate.model.ListParallelDataRequest.ReadOnly =
    zio.aws.translate.model.ListParallelDataRequest.wrap(buildAwsValue())
}
object ListParallelDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.ListParallelDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.ListParallelDataRequest =
      zio.aws.translate.model.ListParallelDataRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResultsInteger]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.ListParallelDataRequest
  ) extends zio.aws.translate.model.ListParallelDataRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.translate.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResultsInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.translate.model.primitives.MaxResultsInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.ListParallelDataRequest
  ): zio.aws.translate.model.ListParallelDataRequest.ReadOnly = new Wrapper(
    impl
  )
}
