package zio.aws.translate.model
import zio.ZIO
import zio.aws.translate.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListParallelDataResponse(
    parallelDataPropertiesList: Optional[
      Iterable[zio.aws.translate.model.ParallelDataProperties]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.ListParallelDataResponse = {
    import ListParallelDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.ListParallelDataResponse
      .builder()
      .optionallyWith(
        parallelDataPropertiesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parallelDataPropertiesList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.translate.model.ListParallelDataResponse.ReadOnly =
    zio.aws.translate.model.ListParallelDataResponse.wrap(buildAwsValue())
}
object ListParallelDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.ListParallelDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.ListParallelDataResponse =
      zio.aws.translate.model.ListParallelDataResponse(
        parallelDataPropertiesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def parallelDataPropertiesList: Optional[
      List[zio.aws.translate.model.ParallelDataProperties.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getParallelDataPropertiesList: ZIO[Any, AwsError, List[
      zio.aws.translate.model.ParallelDataProperties.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "parallelDataPropertiesList",
      parallelDataPropertiesList
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.ListParallelDataResponse
  ) extends zio.aws.translate.model.ListParallelDataResponse.ReadOnly {
    override val parallelDataPropertiesList: Optional[
      List[zio.aws.translate.model.ParallelDataProperties.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parallelDataPropertiesList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.translate.model.ParallelDataProperties.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.translate.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.ListParallelDataResponse
  ): zio.aws.translate.model.ListParallelDataResponse.ReadOnly = new Wrapper(
    impl
  )
}
