package zio.aws.translate.model
import zio.ZIO
import zio.aws.translate.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTerminologiesResponse(
    terminologyPropertiesList: Optional[
      Iterable[zio.aws.translate.model.TerminologyProperties]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.ListTerminologiesResponse = {
    import ListTerminologiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.ListTerminologiesResponse
      .builder()
      .optionallyWith(
        terminologyPropertiesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.terminologyPropertiesList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.translate.model.ListTerminologiesResponse.ReadOnly =
    zio.aws.translate.model.ListTerminologiesResponse.wrap(buildAwsValue())
}
object ListTerminologiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.ListTerminologiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.ListTerminologiesResponse =
      zio.aws.translate.model.ListTerminologiesResponse(
        terminologyPropertiesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def terminologyPropertiesList
        : Optional[List[zio.aws.translate.model.TerminologyProperties.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getTerminologyPropertiesList: ZIO[Any, AwsError, List[
      zio.aws.translate.model.TerminologyProperties.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "terminologyPropertiesList",
      terminologyPropertiesList
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.ListTerminologiesResponse
  ) extends zio.aws.translate.model.ListTerminologiesResponse.ReadOnly {
    override val terminologyPropertiesList: Optional[
      List[zio.aws.translate.model.TerminologyProperties.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.terminologyPropertiesList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.translate.model.TerminologyProperties.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.translate.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.ListTerminologiesResponse
  ): zio.aws.translate.model.ListTerminologiesResponse.ReadOnly = new Wrapper(
    impl
  )
}
