package zio.aws.translate.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.translate.model.primitives.{MaxResultsInteger, NextToken}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListTextTranslationJobsRequest(
    filter: Optional[zio.aws.translate.model.TextTranslationJobFilter] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResultsInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.ListTextTranslationJobsRequest = {
    import ListTextTranslationJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.ListTextTranslationJobsRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResultsInteger.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.translate.model.ListTextTranslationJobsRequest.ReadOnly =
    zio.aws.translate.model.ListTextTranslationJobsRequest.wrap(buildAwsValue())
}
object ListTextTranslationJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.ListTextTranslationJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.ListTextTranslationJobsRequest =
      zio.aws.translate.model.ListTextTranslationJobsRequest(
        filter.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filter
        : Optional[zio.aws.translate.model.TextTranslationJobFilter.ReadOnly]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResultsInteger]
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.translate.model.TextTranslationJobFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.ListTextTranslationJobsRequest
  ) extends zio.aws.translate.model.ListTextTranslationJobsRequest.ReadOnly {
    override val filter
        : Optional[zio.aws.translate.model.TextTranslationJobFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value =>
          zio.aws.translate.model.TextTranslationJobFilter.wrap(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.translate.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResultsInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.translate.model.primitives.MaxResultsInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.ListTextTranslationJobsRequest
  ): zio.aws.translate.model.ListTextTranslationJobsRequest.ReadOnly =
    new Wrapper(impl)
}
