package zio.aws.translate.model
import zio.ZIO
import zio.aws.translate.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTextTranslationJobsResponse(
    textTranslationJobPropertiesList: Optional[
      Iterable[zio.aws.translate.model.TextTranslationJobProperties]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.ListTextTranslationJobsResponse = {
    import ListTextTranslationJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.ListTextTranslationJobsResponse
      .builder()
      .optionallyWith(
        textTranslationJobPropertiesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.textTranslationJobPropertiesList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.translate.model.ListTextTranslationJobsResponse.ReadOnly =
    zio.aws.translate.model.ListTextTranslationJobsResponse
      .wrap(buildAwsValue())
}
object ListTextTranslationJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.ListTextTranslationJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.ListTextTranslationJobsResponse =
      zio.aws.translate.model.ListTextTranslationJobsResponse(
        textTranslationJobPropertiesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def textTranslationJobPropertiesList: Optional[
      List[zio.aws.translate.model.TextTranslationJobProperties.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getTextTranslationJobPropertiesList: ZIO[Any, AwsError, List[
      zio.aws.translate.model.TextTranslationJobProperties.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "textTranslationJobPropertiesList",
      textTranslationJobPropertiesList
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.ListTextTranslationJobsResponse
  ) extends zio.aws.translate.model.ListTextTranslationJobsResponse.ReadOnly {
    override val textTranslationJobPropertiesList: Optional[
      List[zio.aws.translate.model.TextTranslationJobProperties.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.textTranslationJobPropertiesList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.translate.model.TextTranslationJobProperties.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.translate.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.ListTextTranslationJobsResponse
  ): zio.aws.translate.model.ListTextTranslationJobsResponse.ReadOnly =
    new Wrapper(impl)
}
