package zio.aws.translate.model
import scala.jdk.CollectionConverters.*
sealed trait MergeStrategy {
  def unwrap: software.amazon.awssdk.services.translate.model.MergeStrategy
}
object MergeStrategy {
  def wrap(
      value: software.amazon.awssdk.services.translate.model.MergeStrategy
  ): zio.aws.translate.model.MergeStrategy = value match {
    case software.amazon.awssdk.services.translate.model.MergeStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.translate.model.MergeStrategy.OVERWRITE =>
      val r = OVERWRITE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.translate.model.MergeStrategy {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.MergeStrategy =
      software.amazon.awssdk.services.translate.model.MergeStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object OVERWRITE extends zio.aws.translate.model.MergeStrategy {
    override def unwrap
        : software.amazon.awssdk.services.translate.model.MergeStrategy =
      software.amazon.awssdk.services.translate.model.MergeStrategy.OVERWRITE
  }
}
