package zio.aws.translate.model
import zio.ZIO
import zio.aws.translate.model.primitives.S3Uri
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OutputDataConfig(
    s3Uri: S3Uri,
    encryptionKey: Optional[zio.aws.translate.model.EncryptionKey] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.OutputDataConfig = {
    import OutputDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.OutputDataConfig
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .optionallyWith(encryptionKey.map(value => value.buildAwsValue()))(
        _.encryptionKey
      )
      .build()
  }
  def asReadOnly: zio.aws.translate.model.OutputDataConfig.ReadOnly =
    zio.aws.translate.model.OutputDataConfig.wrap(buildAwsValue())
}
object OutputDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.OutputDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.OutputDataConfig =
      zio.aws.translate.model
        .OutputDataConfig(s3Uri, encryptionKey.map(value => value.asEditable))
    def s3Uri: S3Uri
    def encryptionKey: Optional[zio.aws.translate.model.EncryptionKey.ReadOnly]
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
    def getEncryptionKey
        : ZIO[Any, AwsError, zio.aws.translate.model.EncryptionKey.ReadOnly] =
      AwsError.unwrapOptionField("encryptionKey", encryptionKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.OutputDataConfig
  ) extends zio.aws.translate.model.OutputDataConfig.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.translate.model.primitives.S3Uri(impl.s3Uri())
    override val encryptionKey
        : Optional[zio.aws.translate.model.EncryptionKey.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionKey())
        .map(value => zio.aws.translate.model.EncryptionKey.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.OutputDataConfig
  ): zio.aws.translate.model.OutputDataConfig.ReadOnly = new Wrapper(impl)
}
