package zio.aws.translate.model
import zio.ZIO
import zio.aws.translate.model.primitives.S3Uri
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ParallelDataConfig(
    s3Uri: S3Uri,
    format: zio.aws.translate.model.ParallelDataFormat
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.ParallelDataConfig = {
    import ParallelDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.ParallelDataConfig
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .format(format.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.translate.model.ParallelDataConfig.ReadOnly =
    zio.aws.translate.model.ParallelDataConfig.wrap(buildAwsValue())
}
object ParallelDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.ParallelDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.ParallelDataConfig =
      zio.aws.translate.model.ParallelDataConfig(s3Uri, format)
    def s3Uri: S3Uri
    def format: zio.aws.translate.model.ParallelDataFormat
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
    def getFormat
        : ZIO[Any, Nothing, zio.aws.translate.model.ParallelDataFormat] =
      ZIO.succeed(format)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.ParallelDataConfig
  ) extends zio.aws.translate.model.ParallelDataConfig.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.translate.model.primitives.S3Uri(impl.s3Uri())
    override val format: zio.aws.translate.model.ParallelDataFormat =
      zio.aws.translate.model.ParallelDataFormat.wrap(impl.format())
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.ParallelDataConfig
  ): zio.aws.translate.model.ParallelDataConfig.ReadOnly = new Wrapper(impl)
}
