package zio.aws.translate.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ParallelDataDataLocation(
    repositoryType: String,
    location: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.translate.model.ParallelDataDataLocation = {
    import ParallelDataDataLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.translate.model.ParallelDataDataLocation
      .builder()
      .repositoryType(repositoryType: java.lang.String)
      .location(location: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.translate.model.ParallelDataDataLocation.ReadOnly =
    zio.aws.translate.model.ParallelDataDataLocation.wrap(buildAwsValue())
}
object ParallelDataDataLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.translate.model.ParallelDataDataLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.translate.model.ParallelDataDataLocation =
      zio.aws.translate.model.ParallelDataDataLocation(repositoryType, location)
    def repositoryType: String
    def location: String
    def getRepositoryType: ZIO[Any, Nothing, String] =
      ZIO.succeed(repositoryType)
    def getLocation: ZIO[Any, Nothing, String] = ZIO.succeed(location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.translate.model.ParallelDataDataLocation
  ) extends zio.aws.translate.model.ParallelDataDataLocation.ReadOnly {
    override val repositoryType: String = impl.repositoryType(): String
    override val location: String = impl.location(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.translate.model.ParallelDataDataLocation
  ): zio.aws.translate.model.ParallelDataDataLocation.ReadOnly = new Wrapper(
    impl
  )
}
